<?php

namespace Chronopost\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rechercher ServiceType
 * @subpackage Services
 */
class Rechercher extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rechercherContraintesEnlevementV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Chronopost\StructType\RechercherContraintesEnlevementV2 $parameters
     * @return \Chronopost\StructType\RechercherContraintesEnlevementV2Response|bool
     */
    public function rechercherContraintesEnlevementV2(\Chronopost\StructType\RechercherContraintesEnlevementV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rechercherContraintesEnlevementV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named rechercherContraintesEnlevement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Chronopost\StructType\RechercherContraintesEnlevement $parameters
     * @return \Chronopost\StructType\RechercherContraintesEnlevementResponse|bool
     */
    public function rechercherContraintesEnlevement(\Chronopost\StructType\RechercherContraintesEnlevement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rechercherContraintesEnlevement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Chronopost\StructType\RechercherContraintesEnlevementResponse|\Chronopost\StructType\RechercherContraintesEnlevementV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
