<?php

namespace Chronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSkybill StructType
 * Meta information extracted from the WSDL
 * - type: tns:getSkybill
 * @subpackage Structs
 */
class GetSkybill extends AbstractStructBase
{
    /**
     * The numberSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberSearch;
    /**
     * The mode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mode;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $account;
    /**
     * Constructor method for getSkybill
     * @uses GetSkybill::setNumberSearch()
     * @uses GetSkybill::setMode()
     * @uses GetSkybill::setKey()
     * @uses GetSkybill::setAccount()
     * @param string $numberSearch
     * @param string $mode
     * @param string $key
     * @param string $account
     */
    public function __construct($numberSearch = null, $mode = null, $key = null, $account = null)
    {
        $this
            ->setNumberSearch($numberSearch)
            ->setMode($mode)
            ->setKey($key)
            ->setAccount($account);
    }
    /**
     * Get numberSearch value
     * @return string|null
     */
    public function getNumberSearch()
    {
        return $this->numberSearch;
    }
    /**
     * Set numberSearch value
     * @param string $numberSearch
     * @return \Chronopost\StructType\GetSkybill
     */
    public function setNumberSearch($numberSearch = null)
    {
        // validation for constraint: string
        if (!is_null($numberSearch) && !is_string($numberSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberSearch, true), gettype($numberSearch)), __LINE__);
        }
        $this->numberSearch = $numberSearch;
        return $this;
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \Chronopost\StructType\GetSkybill
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mode, true), gettype($mode)), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Chronopost\StructType\GetSkybill
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \Chronopost\StructType\GetSkybill
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
}
