<?php

namespace ChronopostTracking\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Track ServiceType
 * @subpackage Services
 */
class Track extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named trackWithSenderRef
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ChronopostTracking\StructType\TrackWithSenderRef $parameters
     * @return \ChronopostTracking\StructType\TrackWithSenderRefResponse|bool
     */
    public function trackWithSenderRef(\ChronopostTracking\StructType\TrackWithSenderRef $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->trackWithSenderRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named trackSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ChronopostTracking\StructType\TrackSearch $parameters
     * @return \ChronopostTracking\StructType\TrackSearchResponse|bool
     */
    public function trackSearch(\ChronopostTracking\StructType\TrackSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->trackSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named trackSkybillV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ChronopostTracking\StructType\TrackSkybillV2 $parameters
     * @return \ChronopostTracking\StructType\TrackSkybillV2Response|bool
     */
    public function trackSkybillV2(\ChronopostTracking\StructType\TrackSkybillV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->trackSkybillV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named trackSkybill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ChronopostTracking\StructType\TrackSkybill $parameters
     * @return \ChronopostTracking\StructType\TrackSkybillResponse|bool
     */
    public function trackSkybill(\ChronopostTracking\StructType\TrackSkybill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->trackSkybill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ChronopostTracking\StructType\TrackSearchResponse|\ChronopostTracking\StructType\TrackSkybillResponse|\ChronopostTracking\StructType\TrackSkybillV2Response|\ChronopostTracking\StructType\TrackWithSenderRefResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
