<?php

namespace ChronopostTracking;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'resultTrackWithSenderRef' => '\\ChronopostTracking\\StructType\\ResultTrackWithSenderRef',
            'listEvents' => '\\ChronopostTracking\\StructType\\ListEvents',
            'event' => '\\ChronopostTracking\\StructType\\Event',
            'resultTrackSearch' => '\\ChronopostTracking\\StructType\\ResultTrackSearch',
            'infosPOD' => '\\ChronopostTracking\\StructType\\InfosPOD',
            'resultTrackSkybillV2' => '\\ChronopostTracking\\StructType\\ResultTrackSkybillV2',
            'listEventInfoComps' => '\\ChronopostTracking\\StructType\\ListEventInfoComps',
            'eventInfoComp' => '\\ChronopostTracking\\StructType\\EventInfoComp',
            'infoComp' => '\\ChronopostTracking\\StructType\\InfoComp',
            'resultCancelSkybill' => '\\ChronopostTracking\\StructType\\ResultCancelSkybill',
            'resultTrackSkybill' => '\\ChronopostTracking\\StructType\\ResultTrackSkybill',
            'resultSearchPOD' => '\\ChronopostTracking\\StructType\\ResultSearchPOD',
            'resultSearchPODWithSenderRef' => '\\ChronopostTracking\\StructType\\ResultSearchPODWithSenderRef',
            'parcelPOD' => '\\ChronopostTracking\\StructType\\ParcelPOD',
            'trackWithSenderRef' => '\\ChronopostTracking\\StructType\\TrackWithSenderRef',
            'trackWithSenderRefResponse' => '\\ChronopostTracking\\StructType\\TrackWithSenderRefResponse',
            'trackSearch' => '\\ChronopostTracking\\StructType\\TrackSearch',
            'trackSearchResponse' => '\\ChronopostTracking\\StructType\\TrackSearchResponse',
            'trackSkybillV2' => '\\ChronopostTracking\\StructType\\TrackSkybillV2',
            'trackSkybillV2Response' => '\\ChronopostTracking\\StructType\\TrackSkybillV2Response',
            'cancelSkybill' => '\\ChronopostTracking\\StructType\\CancelSkybill',
            'cancelSkybillResponse' => '\\ChronopostTracking\\StructType\\CancelSkybillResponse',
            'trackSkybill' => '\\ChronopostTracking\\StructType\\TrackSkybill',
            'trackSkybillResponse' => '\\ChronopostTracking\\StructType\\TrackSkybillResponse',
            'searchPOD' => '\\ChronopostTracking\\StructType\\SearchPOD',
            'searchPODResponse' => '\\ChronopostTracking\\StructType\\SearchPODResponse',
            'searchPODWithSenderRef' => '\\ChronopostTracking\\StructType\\SearchPODWithSenderRef',
            'searchPODWithSenderRefResponse' => '\\ChronopostTracking\\StructType\\SearchPODWithSenderRefResponse',
        );
    }
}
