<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Demander ServiceType
 * @subpackage Services
 */
class Demander extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Demander
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListesDemandesInfoCanal $demanderRequestPart
     * @return \StructType\ListeRetoursInfoCanal|bool
     */
    public function Demander(\StructType\ListesDemandesInfoCanal $demanderRequestPart)
    {
        try {
            $this->setResult($this->getSoapClient()->Demander($demanderRequestPart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListeRetoursInfoCanal
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
