<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.w3schools.com/xml/tempconvert.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.w3schools.com/xml/tempconvert.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \WsdlGen\ClassMap::get(),
);
/**
 * Samples for Celsius ServiceType
 */
$celsius = new \WsdlGen\Services\Celsius($options);
/**
 * Sample call for FahrenheitToCelsius operation/method
 */
if ($celsius->FahrenheitToCelsius(new \WsdlGen\Structs\FahrenheitToCelsius()) !== false) {
    print_r($celsius->getResult());
} else {
    print_r($celsius->getLastError());
}
/**
 * Samples for Fahrenheit ServiceType
 */
$fahrenheit = new \WsdlGen\Services\Fahrenheit($options);
/**
 * Sample call for CelsiusToFahrenheit operation/method
 */
if ($fahrenheit->CelsiusToFahrenheit(new \WsdlGen\Structs\CelsiusToFahrenheit()) !== false) {
    print_r($fahrenheit->getResult());
} else {
    print_r($fahrenheit->getLastError());
}
