<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Buy ServiceType
 * @subpackage Services
 */
class Buy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named buy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sessionid
     * @param string $buystring
     * @return \StructType\BuyResponseContent|bool
     */
    public function buy($sessionid, $buystring)
    {
        try {
            $this->setResult($this->getSoapClient()->buy($sessionid, $buystring));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BuyResponseContent
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
