<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TunnelOriginalBooking StructType
 * @subpackage Structs
 */
class TunnelOriginalBooking extends AbstractStructBase
{
    /**
     * The BookingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BookingId;
    /**
     * The SaleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SaleDate;
    /**
     * The BeginStay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginStay;
    /**
     * The EndStay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndStay;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The PartnerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartnerId;
    /**
     * The ProductLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductLabel;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for TunnelOriginalBooking
     * @uses TunnelOriginalBooking::setBookingId()
     * @uses TunnelOriginalBooking::setSaleDate()
     * @uses TunnelOriginalBooking::setBeginStay()
     * @uses TunnelOriginalBooking::setEndStay()
     * @uses TunnelOriginalBooking::setTotalPrice()
     * @uses TunnelOriginalBooking::setPartnerId()
     * @uses TunnelOriginalBooking::setProductLabel()
     * @uses TunnelOriginalBooking::setCurrency()
     * @param int $bookingId
     * @param string $saleDate
     * @param string $beginStay
     * @param string $endStay
     * @param float $totalPrice
     * @param int $partnerId
     * @param string $productLabel
     * @param string $currency
     */
    public function __construct($bookingId = null, $saleDate = null, $beginStay = null, $endStay = null, $totalPrice = null, $partnerId = null, $productLabel = null, $currency = null)
    {
        $this
            ->setBookingId($bookingId)
            ->setSaleDate($saleDate)
            ->setBeginStay($beginStay)
            ->setEndStay($endStay)
            ->setTotalPrice($totalPrice)
            ->setPartnerId($partnerId)
            ->setProductLabel($productLabel)
            ->setCurrency($currency);
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\TunnelOriginalBooking
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !(is_int($bookingId) || ctype_digit($bookingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingId, true), gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get SaleDate value
     * @return string
     */
    public function getSaleDate()
    {
        return $this->SaleDate;
    }
    /**
     * Set SaleDate value
     * @param string $saleDate
     * @return \StructType\TunnelOriginalBooking
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleDate, true), gettype($saleDate)), __LINE__);
        }
        $this->SaleDate = $saleDate;
        return $this;
    }
    /**
     * Get BeginStay value
     * @return string
     */
    public function getBeginStay()
    {
        return $this->BeginStay;
    }
    /**
     * Set BeginStay value
     * @param string $beginStay
     * @return \StructType\TunnelOriginalBooking
     */
    public function setBeginStay($beginStay = null)
    {
        // validation for constraint: string
        if (!is_null($beginStay) && !is_string($beginStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginStay, true), gettype($beginStay)), __LINE__);
        }
        $this->BeginStay = $beginStay;
        return $this;
    }
    /**
     * Get EndStay value
     * @return string
     */
    public function getEndStay()
    {
        return $this->EndStay;
    }
    /**
     * Set EndStay value
     * @param string $endStay
     * @return \StructType\TunnelOriginalBooking
     */
    public function setEndStay($endStay = null)
    {
        // validation for constraint: string
        if (!is_null($endStay) && !is_string($endStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endStay, true), gettype($endStay)), __LINE__);
        }
        $this->EndStay = $endStay;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\TunnelOriginalBooking
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get PartnerId value
     * @return int
     */
    public function getPartnerId()
    {
        return $this->PartnerId;
    }
    /**
     * Set PartnerId value
     * @param int $partnerId
     * @return \StructType\TunnelOriginalBooking
     */
    public function setPartnerId($partnerId = null)
    {
        // validation for constraint: int
        if (!is_null($partnerId) && !(is_int($partnerId) || ctype_digit($partnerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partnerId, true), gettype($partnerId)), __LINE__);
        }
        $this->PartnerId = $partnerId;
        return $this;
    }
    /**
     * Get ProductLabel value
     * @return string|null
     */
    public function getProductLabel()
    {
        return $this->ProductLabel;
    }
    /**
     * Set ProductLabel value
     * @param string $productLabel
     * @return \StructType\TunnelOriginalBooking
     */
    public function setProductLabel($productLabel = null)
    {
        // validation for constraint: string
        if (!is_null($productLabel) && !is_string($productLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productLabel, true), gettype($productLabel)), __LINE__);
        }
        $this->ProductLabel = $productLabel;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\TunnelOriginalBooking
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
