<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferBookingFees StructType
 * @subpackage Structs
 */
class OfferBookingFees extends AbstractStructBase
{
    /**
     * The BookingFeesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BookingFeesAmount;
    /**
     * The UniteFraisDossier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UniteFraisDossier;
    /**
     * Constructor method for OfferBookingFees
     * @uses OfferBookingFees::setBookingFeesAmount()
     * @uses OfferBookingFees::setUniteFraisDossier()
     * @param float $bookingFeesAmount
     * @param string $uniteFraisDossier
     */
    public function __construct($bookingFeesAmount = null, $uniteFraisDossier = null)
    {
        $this
            ->setBookingFeesAmount($bookingFeesAmount)
            ->setUniteFraisDossier($uniteFraisDossier);
    }
    /**
     * Get BookingFeesAmount value
     * @return float
     */
    public function getBookingFeesAmount()
    {
        return $this->BookingFeesAmount;
    }
    /**
     * Set BookingFeesAmount value
     * @param float $bookingFeesAmount
     * @return \StructType\OfferBookingFees
     */
    public function setBookingFeesAmount($bookingFeesAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bookingFeesAmount) && !(is_float($bookingFeesAmount) || is_numeric($bookingFeesAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingFeesAmount, true), gettype($bookingFeesAmount)), __LINE__);
        }
        $this->BookingFeesAmount = $bookingFeesAmount;
        return $this;
    }
    /**
     * Get UniteFraisDossier value
     * @return string
     */
    public function getUniteFraisDossier()
    {
        return $this->UniteFraisDossier;
    }
    /**
     * Set UniteFraisDossier value
     * @uses \EnumType\UniteFraisDossier::valueIsValid()
     * @uses \EnumType\UniteFraisDossier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uniteFraisDossier
     * @return \StructType\OfferBookingFees
     */
    public function setUniteFraisDossier($uniteFraisDossier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UniteFraisDossier::valueIsValid($uniteFraisDossier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UniteFraisDossier', is_array($uniteFraisDossier) ? implode(', ', $uniteFraisDossier) : var_export($uniteFraisDossier, true), implode(', ', \EnumType\UniteFraisDossier::getValidValues())), __LINE__);
        }
        $this->UniteFraisDossier = $uniteFraisDossier;
        return $this;
    }
}
