<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionPeriod StructType
 * @subpackage Structs
 */
class OptionPeriod extends AbstractStructBase
{
    /**
     * The Begin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Begin;
    /**
     * The EndIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndIncluded;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * Constructor method for OptionPeriod
     * @uses OptionPeriod::setBegin()
     * @uses OptionPeriod::setEndIncluded()
     * @uses OptionPeriod::setPrice()
     * @param string $begin
     * @param string $endIncluded
     * @param float $price
     */
    public function __construct($begin = null, $endIncluded = null, $price = null)
    {
        $this
            ->setBegin($begin)
            ->setEndIncluded($endIncluded)
            ->setPrice($price);
    }
    /**
     * Get Begin value
     * @return string
     */
    public function getBegin()
    {
        return $this->Begin;
    }
    /**
     * Set Begin value
     * @param string $begin
     * @return \StructType\OptionPeriod
     */
    public function setBegin($begin = null)
    {
        // validation for constraint: string
        if (!is_null($begin) && !is_string($begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($begin, true), gettype($begin)), __LINE__);
        }
        $this->Begin = $begin;
        return $this;
    }
    /**
     * Get EndIncluded value
     * @return string
     */
    public function getEndIncluded()
    {
        return $this->EndIncluded;
    }
    /**
     * Set EndIncluded value
     * @param string $endIncluded
     * @return \StructType\OptionPeriod
     */
    public function setEndIncluded($endIncluded = null)
    {
        // validation for constraint: string
        if (!is_null($endIncluded) && !is_string($endIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endIncluded, true), gettype($endIncluded)), __LINE__);
        }
        $this->EndIncluded = $endIncluded;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\OptionPeriod
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
}
