<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialOfferFilter StructType
 * @subpackage Structs
 */
class SpecialOfferFilter extends AbstractStructBase
{
    /**
     * The lastMinute
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $lastMinute;
    /**
     * The weekEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $weekEnd;
    /**
     * The flash
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $flash;
    /**
     * The exclusive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $exclusive;
    /**
     * The ExcludeNonOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeNonOffer;
    /**
     * The IncludeClassicOffers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeClassicOffers;
    /**
     * The campaignWSCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $campaignWSCode;
    /**
     * The seasons
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSeasonEnum
     */
    public $seasons;
    /**
     * The idsClassicOffersPeriods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $idsClassicOffersPeriods;
    /**
     * The offerTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTypeOS
     */
    public $offerTypes;
    /**
     * The idsInjectedOffers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $idsInjectedOffers;
    /**
     * The includeExpiredOffers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeExpiredOffers;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountCode;
    /**
     * Constructor method for SpecialOfferFilter
     * @uses SpecialOfferFilter::setLastMinute()
     * @uses SpecialOfferFilter::setWeekEnd()
     * @uses SpecialOfferFilter::setFlash()
     * @uses SpecialOfferFilter::setExclusive()
     * @uses SpecialOfferFilter::setExcludeNonOffer()
     * @uses SpecialOfferFilter::setIncludeClassicOffers()
     * @uses SpecialOfferFilter::setCampaignWSCode()
     * @uses SpecialOfferFilter::setSeasons()
     * @uses SpecialOfferFilter::setIdsClassicOffersPeriods()
     * @uses SpecialOfferFilter::setOfferTypes()
     * @uses SpecialOfferFilter::setIdsInjectedOffers()
     * @uses SpecialOfferFilter::setIncludeExpiredOffers()
     * @uses SpecialOfferFilter::setDiscountCode()
     * @param bool $lastMinute
     * @param bool $weekEnd
     * @param bool $flash
     * @param bool $exclusive
     * @param bool $excludeNonOffer
     * @param bool $includeClassicOffers
     * @param string $campaignWSCode
     * @param \ArrayType\ArrayOfSeasonEnum $seasons
     * @param \ArrayType\ArrayOfInt $idsClassicOffersPeriods
     * @param \ArrayType\ArrayOfTypeOS $offerTypes
     * @param \ArrayType\ArrayOfInt $idsInjectedOffers
     * @param bool $includeExpiredOffers
     * @param string $discountCode
     */
    public function __construct($lastMinute = null, $weekEnd = null, $flash = null, $exclusive = null, $excludeNonOffer = null, $includeClassicOffers = null, $campaignWSCode = null, \ArrayType\ArrayOfSeasonEnum $seasons = null, \ArrayType\ArrayOfInt $idsClassicOffersPeriods = null, \ArrayType\ArrayOfTypeOS $offerTypes = null, \ArrayType\ArrayOfInt $idsInjectedOffers = null, $includeExpiredOffers = null, $discountCode = null)
    {
        $this
            ->setLastMinute($lastMinute)
            ->setWeekEnd($weekEnd)
            ->setFlash($flash)
            ->setExclusive($exclusive)
            ->setExcludeNonOffer($excludeNonOffer)
            ->setIncludeClassicOffers($includeClassicOffers)
            ->setCampaignWSCode($campaignWSCode)
            ->setSeasons($seasons)
            ->setIdsClassicOffersPeriods($idsClassicOffersPeriods)
            ->setOfferTypes($offerTypes)
            ->setIdsInjectedOffers($idsInjectedOffers)
            ->setIncludeExpiredOffers($includeExpiredOffers)
            ->setDiscountCode($discountCode);
    }
    /**
     * Get lastMinute value
     * @return bool
     */
    public function getLastMinute()
    {
        return $this->lastMinute;
    }
    /**
     * Set lastMinute value
     * @param bool $lastMinute
     * @return \StructType\SpecialOfferFilter
     */
    public function setLastMinute($lastMinute = null)
    {
        // validation for constraint: boolean
        if (!is_null($lastMinute) && !is_bool($lastMinute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lastMinute, true), gettype($lastMinute)), __LINE__);
        }
        $this->lastMinute = $lastMinute;
        return $this;
    }
    /**
     * Get weekEnd value
     * @return bool
     */
    public function getWeekEnd()
    {
        return $this->weekEnd;
    }
    /**
     * Set weekEnd value
     * @param bool $weekEnd
     * @return \StructType\SpecialOfferFilter
     */
    public function setWeekEnd($weekEnd = null)
    {
        // validation for constraint: boolean
        if (!is_null($weekEnd) && !is_bool($weekEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weekEnd, true), gettype($weekEnd)), __LINE__);
        }
        $this->weekEnd = $weekEnd;
        return $this;
    }
    /**
     * Get flash value
     * @return bool
     */
    public function getFlash()
    {
        return $this->flash;
    }
    /**
     * Set flash value
     * @param bool $flash
     * @return \StructType\SpecialOfferFilter
     */
    public function setFlash($flash = null)
    {
        // validation for constraint: boolean
        if (!is_null($flash) && !is_bool($flash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flash, true), gettype($flash)), __LINE__);
        }
        $this->flash = $flash;
        return $this;
    }
    /**
     * Get exclusive value
     * @return bool
     */
    public function getExclusive()
    {
        return $this->exclusive;
    }
    /**
     * Set exclusive value
     * @param bool $exclusive
     * @return \StructType\SpecialOfferFilter
     */
    public function setExclusive($exclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclusive) && !is_bool($exclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclusive, true), gettype($exclusive)), __LINE__);
        }
        $this->exclusive = $exclusive;
        return $this;
    }
    /**
     * Get ExcludeNonOffer value
     * @return bool
     */
    public function getExcludeNonOffer()
    {
        return $this->ExcludeNonOffer;
    }
    /**
     * Set ExcludeNonOffer value
     * @param bool $excludeNonOffer
     * @return \StructType\SpecialOfferFilter
     */
    public function setExcludeNonOffer($excludeNonOffer = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeNonOffer) && !is_bool($excludeNonOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeNonOffer, true), gettype($excludeNonOffer)), __LINE__);
        }
        $this->ExcludeNonOffer = $excludeNonOffer;
        return $this;
    }
    /**
     * Get IncludeClassicOffers value
     * @return bool
     */
    public function getIncludeClassicOffers()
    {
        return $this->IncludeClassicOffers;
    }
    /**
     * Set IncludeClassicOffers value
     * @param bool $includeClassicOffers
     * @return \StructType\SpecialOfferFilter
     */
    public function setIncludeClassicOffers($includeClassicOffers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeClassicOffers) && !is_bool($includeClassicOffers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeClassicOffers, true), gettype($includeClassicOffers)), __LINE__);
        }
        $this->IncludeClassicOffers = $includeClassicOffers;
        return $this;
    }
    /**
     * Get campaignWSCode value
     * @return string|null
     */
    public function getCampaignWSCode()
    {
        return $this->campaignWSCode;
    }
    /**
     * Set campaignWSCode value
     * @param string $campaignWSCode
     * @return \StructType\SpecialOfferFilter
     */
    public function setCampaignWSCode($campaignWSCode = null)
    {
        // validation for constraint: string
        if (!is_null($campaignWSCode) && !is_string($campaignWSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignWSCode, true), gettype($campaignWSCode)), __LINE__);
        }
        $this->campaignWSCode = $campaignWSCode;
        return $this;
    }
    /**
     * Get seasons value
     * @return \ArrayType\ArrayOfSeasonEnum|null
     */
    public function getSeasons()
    {
        return $this->seasons;
    }
    /**
     * Set seasons value
     * @param \ArrayType\ArrayOfSeasonEnum $seasons
     * @return \StructType\SpecialOfferFilter
     */
    public function setSeasons(\ArrayType\ArrayOfSeasonEnum $seasons = null)
    {
        $this->seasons = $seasons;
        return $this;
    }
    /**
     * Get idsClassicOffersPeriods value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getIdsClassicOffersPeriods()
    {
        return $this->idsClassicOffersPeriods;
    }
    /**
     * Set idsClassicOffersPeriods value
     * @param \ArrayType\ArrayOfInt $idsClassicOffersPeriods
     * @return \StructType\SpecialOfferFilter
     */
    public function setIdsClassicOffersPeriods(\ArrayType\ArrayOfInt $idsClassicOffersPeriods = null)
    {
        $this->idsClassicOffersPeriods = $idsClassicOffersPeriods;
        return $this;
    }
    /**
     * Get offerTypes value
     * @return \ArrayType\ArrayOfTypeOS|null
     */
    public function getOfferTypes()
    {
        return $this->offerTypes;
    }
    /**
     * Set offerTypes value
     * @param \ArrayType\ArrayOfTypeOS $offerTypes
     * @return \StructType\SpecialOfferFilter
     */
    public function setOfferTypes(\ArrayType\ArrayOfTypeOS $offerTypes = null)
    {
        $this->offerTypes = $offerTypes;
        return $this;
    }
    /**
     * Get idsInjectedOffers value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getIdsInjectedOffers()
    {
        return $this->idsInjectedOffers;
    }
    /**
     * Set idsInjectedOffers value
     * @param \ArrayType\ArrayOfInt $idsInjectedOffers
     * @return \StructType\SpecialOfferFilter
     */
    public function setIdsInjectedOffers(\ArrayType\ArrayOfInt $idsInjectedOffers = null)
    {
        $this->idsInjectedOffers = $idsInjectedOffers;
        return $this;
    }
    /**
     * Get includeExpiredOffers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeExpiredOffers()
    {
        return isset($this->includeExpiredOffers) ? $this->includeExpiredOffers : null;
    }
    /**
     * Set includeExpiredOffers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeExpiredOffers
     * @return \StructType\SpecialOfferFilter
     */
    public function setIncludeExpiredOffers($includeExpiredOffers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeExpiredOffers) && !is_bool($includeExpiredOffers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeExpiredOffers, true), gettype($includeExpiredOffers)), __LINE__);
        }
        if (is_null($includeExpiredOffers) || (is_array($includeExpiredOffers) && empty($includeExpiredOffers))) {
            unset($this->includeExpiredOffers);
        } else {
            $this->includeExpiredOffers = $includeExpiredOffers;
        }
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\SpecialOfferFilter
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
}
