<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemInfo StructType
 * @subpackage Structs
 */
class ItemInfo extends AbstractStructBase
{
    /**
     * The myKey
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $myKey;
    /**
     * The HasValue
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $HasValue;
    /**
     * The prem
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $prem;
    /**
     * The myTranslatedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myTranslatedName;
    /**
     * The myValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ItemTypeValue
     */
    public $myValue;
    /**
     * The mySubItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemInfo[]
     */
    public $mySubItems;
    /**
     * The myEntities
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EntityInfo[]
     */
    public $myEntities;
    /**
     * The myCode
     * @var string
     */
    public $myCode;
    /**
     * The myDisplayValue
     * @var string
     */
    public $myDisplayValue;
    /**
     * Constructor method for itemInfo
     * @uses ItemInfo::setMyKey()
     * @uses ItemInfo::setHasValue()
     * @uses ItemInfo::setPrem()
     * @uses ItemInfo::setMyTranslatedName()
     * @uses ItemInfo::setMyValue()
     * @uses ItemInfo::setMySubItems()
     * @uses ItemInfo::setMyEntities()
     * @uses ItemInfo::setMyCode()
     * @uses ItemInfo::setMyDisplayValue()
     * @param int $myKey
     * @param bool $hasValue
     * @param bool $prem
     * @param string $myTranslatedName
     * @param \StructType\ItemTypeValue $myValue
     * @param \StructType\ItemInfo[] $mySubItems
     * @param \StructType\EntityInfo[] $myEntities
     * @param string $myCode
     * @param string $myDisplayValue
     */
    public function __construct($myKey = null, $hasValue = null, $prem = null, $myTranslatedName = null, \StructType\ItemTypeValue $myValue = null, array $mySubItems = array(), array $myEntities = array(), $myCode = null, $myDisplayValue = null)
    {
        $this
            ->setMyKey($myKey)
            ->setHasValue($hasValue)
            ->setPrem($prem)
            ->setMyTranslatedName($myTranslatedName)
            ->setMyValue($myValue)
            ->setMySubItems($mySubItems)
            ->setMyEntities($myEntities)
            ->setMyCode($myCode)
            ->setMyDisplayValue($myDisplayValue);
    }
    /**
     * Get myKey value
     * @return int
     */
    public function getMyKey()
    {
        return $this->myKey;
    }
    /**
     * Set myKey value
     * @param int $myKey
     * @return \StructType\ItemInfo
     */
    public function setMyKey($myKey = null)
    {
        // validation for constraint: int
        if (!is_null($myKey) && !(is_int($myKey) || ctype_digit($myKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myKey, true), gettype($myKey)), __LINE__);
        }
        $this->myKey = $myKey;
        return $this;
    }
    /**
     * Get HasValue value
     * @return bool
     */
    public function getHasValue()
    {
        return $this->HasValue;
    }
    /**
     * Set HasValue value
     * @param bool $hasValue
     * @return \StructType\ItemInfo
     */
    public function setHasValue($hasValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasValue) && !is_bool($hasValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasValue, true), gettype($hasValue)), __LINE__);
        }
        $this->HasValue = $hasValue;
        return $this;
    }
    /**
     * Get prem value
     * @return bool
     */
    public function getPrem()
    {
        return $this->prem;
    }
    /**
     * Set prem value
     * @param bool $prem
     * @return \StructType\ItemInfo
     */
    public function setPrem($prem = null)
    {
        // validation for constraint: boolean
        if (!is_null($prem) && !is_bool($prem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prem, true), gettype($prem)), __LINE__);
        }
        $this->prem = $prem;
        return $this;
    }
    /**
     * Get myTranslatedName value
     * @return string|null
     */
    public function getMyTranslatedName()
    {
        return $this->myTranslatedName;
    }
    /**
     * Set myTranslatedName value
     * @param string $myTranslatedName
     * @return \StructType\ItemInfo
     */
    public function setMyTranslatedName($myTranslatedName = null)
    {
        // validation for constraint: string
        if (!is_null($myTranslatedName) && !is_string($myTranslatedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myTranslatedName, true), gettype($myTranslatedName)), __LINE__);
        }
        $this->myTranslatedName = $myTranslatedName;
        return $this;
    }
    /**
     * Get myValue value
     * @return \StructType\ItemTypeValue|null
     */
    public function getMyValue()
    {
        return $this->myValue;
    }
    /**
     * Set myValue value
     * @param \StructType\ItemTypeValue $myValue
     * @return \StructType\ItemInfo
     */
    public function setMyValue(\StructType\ItemTypeValue $myValue = null)
    {
        $this->myValue = $myValue;
        return $this;
    }
    /**
     * Get mySubItems value
     * @return \StructType\ItemInfo[]|null
     */
    public function getMySubItems()
    {
        return $this->mySubItems;
    }
    /**
     * This method is responsible for validating the values passed to the setMySubItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMySubItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMySubItemsForArrayConstraintsFromSetMySubItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemInfoMySubItemsItem) {
            // validation for constraint: itemType
            if (!$itemInfoMySubItemsItem instanceof \StructType\ItemInfo) {
                $invalidValues[] = is_object($itemInfoMySubItemsItem) ? get_class($itemInfoMySubItemsItem) : sprintf('%s(%s)', gettype($itemInfoMySubItemsItem), var_export($itemInfoMySubItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mySubItems property can only contain items of type \StructType\ItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mySubItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo[] $mySubItems
     * @return \StructType\ItemInfo
     */
    public function setMySubItems(array $mySubItems = array())
    {
        // validation for constraint: array
        if ('' !== ($mySubItemsArrayErrorMessage = self::validateMySubItemsForArrayConstraintsFromSetMySubItems($mySubItems))) {
            throw new \InvalidArgumentException($mySubItemsArrayErrorMessage, __LINE__);
        }
        $this->mySubItems = $mySubItems;
        return $this;
    }
    /**
     * Add item to mySubItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo $item
     * @return \StructType\ItemInfo
     */
    public function addToMySubItems(\StructType\ItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemInfo) {
            throw new \InvalidArgumentException(sprintf('The mySubItems property can only contain items of type \StructType\ItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mySubItems[] = $item;
        return $this;
    }
    /**
     * Get myEntities value
     * @return \StructType\EntityInfo[]|null
     */
    public function getMyEntities()
    {
        return $this->myEntities;
    }
    /**
     * This method is responsible for validating the values passed to the setMyEntities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyEntities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyEntitiesForArrayConstraintsFromSetMyEntities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemInfoMyEntitiesItem) {
            // validation for constraint: itemType
            if (!$itemInfoMyEntitiesItem instanceof \StructType\EntityInfo) {
                $invalidValues[] = is_object($itemInfoMyEntitiesItem) ? get_class($itemInfoMyEntitiesItem) : sprintf('%s(%s)', gettype($itemInfoMyEntitiesItem), var_export($itemInfoMyEntitiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myEntities property can only contain items of type \StructType\EntityInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myEntities value
     * @throws \InvalidArgumentException
     * @param \StructType\EntityInfo[] $myEntities
     * @return \StructType\ItemInfo
     */
    public function setMyEntities(array $myEntities = array())
    {
        // validation for constraint: array
        if ('' !== ($myEntitiesArrayErrorMessage = self::validateMyEntitiesForArrayConstraintsFromSetMyEntities($myEntities))) {
            throw new \InvalidArgumentException($myEntitiesArrayErrorMessage, __LINE__);
        }
        $this->myEntities = $myEntities;
        return $this;
    }
    /**
     * Add item to myEntities value
     * @throws \InvalidArgumentException
     * @param \StructType\EntityInfo $item
     * @return \StructType\ItemInfo
     */
    public function addToMyEntities(\StructType\EntityInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EntityInfo) {
            throw new \InvalidArgumentException(sprintf('The myEntities property can only contain items of type \StructType\EntityInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myEntities[] = $item;
        return $this;
    }
    /**
     * Get myCode value
     * @return string|null
     */
    public function getMyCode()
    {
        return $this->myCode;
    }
    /**
     * Set myCode value
     * @param string $myCode
     * @return \StructType\ItemInfo
     */
    public function setMyCode($myCode = null)
    {
        // validation for constraint: string
        if (!is_null($myCode) && !is_string($myCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myCode, true), gettype($myCode)), __LINE__);
        }
        $this->myCode = $myCode;
        return $this;
    }
    /**
     * Get myDisplayValue value
     * @return string|null
     */
    public function getMyDisplayValue()
    {
        return $this->myDisplayValue;
    }
    /**
     * Set myDisplayValue value
     * @param string $myDisplayValue
     * @return \StructType\ItemInfo
     */
    public function setMyDisplayValue($myDisplayValue = null)
    {
        // validation for constraint: string
        if (!is_null($myDisplayValue) && !is_string($myDisplayValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myDisplayValue, true), gettype($myDisplayValue)), __LINE__);
        }
        $this->myDisplayValue = $myDisplayValue;
        return $this;
    }
}
