<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailByPeriod StructType
 * @subpackage Structs
 */
class DetailByPeriod extends AbstractStructBase
{
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The NbNight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NbNight;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $State;
    /**
     * The ResaId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ResaId;
    /**
     * Constructor method for DetailByPeriod
     * @uses DetailByPeriod::setBeginDate()
     * @uses DetailByPeriod::setNbNight()
     * @uses DetailByPeriod::setState()
     * @uses DetailByPeriod::setResaId()
     * @param string $beginDate
     * @param int $nbNight
     * @param string $state
     * @param int $resaId
     */
    public function __construct($beginDate = null, $nbNight = null, $state = null, $resaId = null)
    {
        $this
            ->setBeginDate($beginDate)
            ->setNbNight($nbNight)
            ->setState($state)
            ->setResaId($resaId);
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\DetailByPeriod
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get NbNight value
     * @return int
     */
    public function getNbNight()
    {
        return $this->NbNight;
    }
    /**
     * Set NbNight value
     * @param int $nbNight
     * @return \StructType\DetailByPeriod
     */
    public function setNbNight($nbNight = null)
    {
        // validation for constraint: int
        if (!is_null($nbNight) && !(is_int($nbNight) || ctype_digit($nbNight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbNight, true), gettype($nbNight)), __LINE__);
        }
        $this->NbNight = $nbNight;
        return $this;
    }
    /**
     * Get State value
     * @return string
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \EnumType\EnumEtat::valueIsValid()
     * @uses \EnumType\EnumEtat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\DetailByPeriod
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumEtat::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumEtat', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\EnumEtat::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ResaId value
     * @return int
     */
    public function getResaId()
    {
        return $this->ResaId;
    }
    /**
     * Set ResaId value
     * @param int $resaId
     * @return \StructType\DetailByPeriod
     */
    public function setResaId($resaId = null)
    {
        // validation for constraint: int
        if (!is_null($resaId) && !(is_int($resaId) || ctype_digit($resaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resaId, true), gettype($resaId)), __LINE__);
        }
        $this->ResaId = $resaId;
        return $this;
    }
}
