<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Detail StructType
 * @subpackage Structs
 */
class Detail extends AbstractStructBase
{
    /**
     * The AllotID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AllotID;
    /**
     * The DateDuJour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateDuJour;
    /**
     * The MyEnumEtat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MyEnumEtat;
    /**
     * The ResaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ResaID;
    /**
     * The CodeJourSemaine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodeJourSemaine;
    /**
     * Constructor method for Detail
     * @uses Detail::setAllotID()
     * @uses Detail::setDateDuJour()
     * @uses Detail::setMyEnumEtat()
     * @uses Detail::setResaID()
     * @uses Detail::setCodeJourSemaine()
     * @param int $allotID
     * @param string $dateDuJour
     * @param string $myEnumEtat
     * @param int $resaID
     * @param int $codeJourSemaine
     */
    public function __construct($allotID = null, $dateDuJour = null, $myEnumEtat = null, $resaID = null, $codeJourSemaine = null)
    {
        $this
            ->setAllotID($allotID)
            ->setDateDuJour($dateDuJour)
            ->setMyEnumEtat($myEnumEtat)
            ->setResaID($resaID)
            ->setCodeJourSemaine($codeJourSemaine);
    }
    /**
     * Get AllotID value
     * @return int
     */
    public function getAllotID()
    {
        return $this->AllotID;
    }
    /**
     * Set AllotID value
     * @param int $allotID
     * @return \StructType\Detail
     */
    public function setAllotID($allotID = null)
    {
        // validation for constraint: int
        if (!is_null($allotID) && !(is_int($allotID) || ctype_digit($allotID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allotID, true), gettype($allotID)), __LINE__);
        }
        $this->AllotID = $allotID;
        return $this;
    }
    /**
     * Get DateDuJour value
     * @return string
     */
    public function getDateDuJour()
    {
        return $this->DateDuJour;
    }
    /**
     * Set DateDuJour value
     * @param string $dateDuJour
     * @return \StructType\Detail
     */
    public function setDateDuJour($dateDuJour = null)
    {
        // validation for constraint: string
        if (!is_null($dateDuJour) && !is_string($dateDuJour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDuJour, true), gettype($dateDuJour)), __LINE__);
        }
        $this->DateDuJour = $dateDuJour;
        return $this;
    }
    /**
     * Get MyEnumEtat value
     * @return string
     */
    public function getMyEnumEtat()
    {
        return $this->MyEnumEtat;
    }
    /**
     * Set MyEnumEtat value
     * @uses \EnumType\EnumEtat::valueIsValid()
     * @uses \EnumType\EnumEtat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $myEnumEtat
     * @return \StructType\Detail
     */
    public function setMyEnumEtat($myEnumEtat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumEtat::valueIsValid($myEnumEtat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumEtat', is_array($myEnumEtat) ? implode(', ', $myEnumEtat) : var_export($myEnumEtat, true), implode(', ', \EnumType\EnumEtat::getValidValues())), __LINE__);
        }
        $this->MyEnumEtat = $myEnumEtat;
        return $this;
    }
    /**
     * Get ResaID value
     * @return int
     */
    public function getResaID()
    {
        return $this->ResaID;
    }
    /**
     * Set ResaID value
     * @param int $resaID
     * @return \StructType\Detail
     */
    public function setResaID($resaID = null)
    {
        // validation for constraint: int
        if (!is_null($resaID) && !(is_int($resaID) || ctype_digit($resaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resaID, true), gettype($resaID)), __LINE__);
        }
        $this->ResaID = $resaID;
        return $this;
    }
    /**
     * Get CodeJourSemaine value
     * @return int
     */
    public function getCodeJourSemaine()
    {
        return $this->CodeJourSemaine;
    }
    /**
     * Set CodeJourSemaine value
     * @param int $codeJourSemaine
     * @return \StructType\Detail
     */
    public function setCodeJourSemaine($codeJourSemaine = null)
    {
        // validation for constraint: int
        if (!is_null($codeJourSemaine) && !(is_int($codeJourSemaine) || ctype_digit($codeJourSemaine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeJourSemaine, true), gettype($codeJourSemaine)), __LINE__);
        }
        $this->CodeJourSemaine = $codeJourSemaine;
        return $this;
    }
}
