<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckQuote StructType
 * @subpackage Structs
 */
class CheckQuote extends AbstractStructBase
{
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $language;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WSUser
     */
    public $user;
    /**
     * The stayIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StayIdentifier
     */
    public $stayIdentifier;
    /**
     * The checkQuoteParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CheckQuoteParameters
     */
    public $checkQuoteParameters;
    /**
     * Constructor method for CheckQuote
     * @uses CheckQuote::setLanguage()
     * @uses CheckQuote::setUser()
     * @uses CheckQuote::setStayIdentifier()
     * @uses CheckQuote::setCheckQuoteParameters()
     * @param string $language
     * @param \StructType\WSUser $user
     * @param \StructType\StayIdentifier $stayIdentifier
     * @param \StructType\CheckQuoteParameters $checkQuoteParameters
     */
    public function __construct($language = null, \StructType\WSUser $user = null, \StructType\StayIdentifier $stayIdentifier = null, \StructType\CheckQuoteParameters $checkQuoteParameters = null)
    {
        $this
            ->setLanguage($language)
            ->setUser($user)
            ->setStayIdentifier($stayIdentifier)
            ->setCheckQuoteParameters($checkQuoteParameters);
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\Lang::valueIsValid()
     * @uses \EnumType\Lang::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\CheckQuote
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Lang::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Lang', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\Lang::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get user value
     * @return \StructType\WSUser|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param \StructType\WSUser $user
     * @return \StructType\CheckQuote
     */
    public function setUser(\StructType\WSUser $user = null)
    {
        $this->user = $user;
        return $this;
    }
    /**
     * Get stayIdentifier value
     * @return \StructType\StayIdentifier|null
     */
    public function getStayIdentifier()
    {
        return $this->stayIdentifier;
    }
    /**
     * Set stayIdentifier value
     * @param \StructType\StayIdentifier $stayIdentifier
     * @return \StructType\CheckQuote
     */
    public function setStayIdentifier(\StructType\StayIdentifier $stayIdentifier = null)
    {
        $this->stayIdentifier = $stayIdentifier;
        return $this;
    }
    /**
     * Get checkQuoteParameters value
     * @return \StructType\CheckQuoteParameters|null
     */
    public function getCheckQuoteParameters()
    {
        return $this->checkQuoteParameters;
    }
    /**
     * Set checkQuoteParameters value
     * @param \StructType\CheckQuoteParameters $checkQuoteParameters
     * @return \StructType\CheckQuote
     */
    public function setCheckQuoteParameters(\StructType\CheckQuoteParameters $checkQuoteParameters = null)
    {
        $this->checkQuoteParameters = $checkQuoteParameters;
        return $this;
    }
}
