<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for baseEntityInfo StructType
 * @subpackage Structs
 */
abstract class BaseEntityInfo extends AbstractStructBase
{
    /**
     * The myKey
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $myKey;
    /**
     * The myTypeKey
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $myTypeKey;
    /**
     * The myName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myName;
    /**
     * The myPhotos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhotoInfo[]
     */
    public $myPhotos;
    /**
     * The myThematics
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ThematicInfo[]
     */
    public $myThematics;
    /**
     * The myType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myType;
    /**
     * Constructor method for baseEntityInfo
     * @uses BaseEntityInfo::setMyKey()
     * @uses BaseEntityInfo::setMyTypeKey()
     * @uses BaseEntityInfo::setMyName()
     * @uses BaseEntityInfo::setMyPhotos()
     * @uses BaseEntityInfo::setMyThematics()
     * @uses BaseEntityInfo::setMyType()
     * @param int $myKey
     * @param int $myTypeKey
     * @param string $myName
     * @param \StructType\PhotoInfo[] $myPhotos
     * @param \StructType\ThematicInfo[] $myThematics
     * @param string $myType
     */
    public function __construct($myKey = null, $myTypeKey = null, $myName = null, array $myPhotos = array(), array $myThematics = array(), $myType = null)
    {
        $this
            ->setMyKey($myKey)
            ->setMyTypeKey($myTypeKey)
            ->setMyName($myName)
            ->setMyPhotos($myPhotos)
            ->setMyThematics($myThematics)
            ->setMyType($myType);
    }
    /**
     * Get myKey value
     * @return int
     */
    public function getMyKey()
    {
        return $this->myKey;
    }
    /**
     * Set myKey value
     * @param int $myKey
     * @return \StructType\BaseEntityInfo
     */
    public function setMyKey($myKey = null)
    {
        // validation for constraint: int
        if (!is_null($myKey) && !(is_int($myKey) || ctype_digit($myKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myKey, true), gettype($myKey)), __LINE__);
        }
        $this->myKey = $myKey;
        return $this;
    }
    /**
     * Get myTypeKey value
     * @return int
     */
    public function getMyTypeKey()
    {
        return $this->myTypeKey;
    }
    /**
     * Set myTypeKey value
     * @param int $myTypeKey
     * @return \StructType\BaseEntityInfo
     */
    public function setMyTypeKey($myTypeKey = null)
    {
        // validation for constraint: int
        if (!is_null($myTypeKey) && !(is_int($myTypeKey) || ctype_digit($myTypeKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myTypeKey, true), gettype($myTypeKey)), __LINE__);
        }
        $this->myTypeKey = $myTypeKey;
        return $this;
    }
    /**
     * Get myName value
     * @return string|null
     */
    public function getMyName()
    {
        return $this->myName;
    }
    /**
     * Set myName value
     * @param string $myName
     * @return \StructType\BaseEntityInfo
     */
    public function setMyName($myName = null)
    {
        // validation for constraint: string
        if (!is_null($myName) && !is_string($myName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myName, true), gettype($myName)), __LINE__);
        }
        $this->myName = $myName;
        return $this;
    }
    /**
     * Get myPhotos value
     * @return \StructType\PhotoInfo[]|null
     */
    public function getMyPhotos()
    {
        return $this->myPhotos;
    }
    /**
     * This method is responsible for validating the values passed to the setMyPhotos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyPhotos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyPhotosForArrayConstraintsFromSetMyPhotos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baseEntityInfoMyPhotosItem) {
            // validation for constraint: itemType
            if (!$baseEntityInfoMyPhotosItem instanceof \StructType\PhotoInfo) {
                $invalidValues[] = is_object($baseEntityInfoMyPhotosItem) ? get_class($baseEntityInfoMyPhotosItem) : sprintf('%s(%s)', gettype($baseEntityInfoMyPhotosItem), var_export($baseEntityInfoMyPhotosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myPhotos property can only contain items of type \StructType\PhotoInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myPhotos value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoInfo[] $myPhotos
     * @return \StructType\BaseEntityInfo
     */
    public function setMyPhotos(array $myPhotos = array())
    {
        // validation for constraint: array
        if ('' !== ($myPhotosArrayErrorMessage = self::validateMyPhotosForArrayConstraintsFromSetMyPhotos($myPhotos))) {
            throw new \InvalidArgumentException($myPhotosArrayErrorMessage, __LINE__);
        }
        $this->myPhotos = $myPhotos;
        return $this;
    }
    /**
     * Add item to myPhotos value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoInfo $item
     * @return \StructType\BaseEntityInfo
     */
    public function addToMyPhotos(\StructType\PhotoInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhotoInfo) {
            throw new \InvalidArgumentException(sprintf('The myPhotos property can only contain items of type \StructType\PhotoInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myPhotos[] = $item;
        return $this;
    }
    /**
     * Get myThematics value
     * @return \StructType\ThematicInfo[]|null
     */
    public function getMyThematics()
    {
        return $this->myThematics;
    }
    /**
     * This method is responsible for validating the values passed to the setMyThematics method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyThematics method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyThematicsForArrayConstraintsFromSetMyThematics(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baseEntityInfoMyThematicsItem) {
            // validation for constraint: itemType
            if (!$baseEntityInfoMyThematicsItem instanceof \StructType\ThematicInfo) {
                $invalidValues[] = is_object($baseEntityInfoMyThematicsItem) ? get_class($baseEntityInfoMyThematicsItem) : sprintf('%s(%s)', gettype($baseEntityInfoMyThematicsItem), var_export($baseEntityInfoMyThematicsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myThematics property can only contain items of type \StructType\ThematicInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myThematics value
     * @throws \InvalidArgumentException
     * @param \StructType\ThematicInfo[] $myThematics
     * @return \StructType\BaseEntityInfo
     */
    public function setMyThematics(array $myThematics = array())
    {
        // validation for constraint: array
        if ('' !== ($myThematicsArrayErrorMessage = self::validateMyThematicsForArrayConstraintsFromSetMyThematics($myThematics))) {
            throw new \InvalidArgumentException($myThematicsArrayErrorMessage, __LINE__);
        }
        $this->myThematics = $myThematics;
        return $this;
    }
    /**
     * Add item to myThematics value
     * @throws \InvalidArgumentException
     * @param \StructType\ThematicInfo $item
     * @return \StructType\BaseEntityInfo
     */
    public function addToMyThematics(\StructType\ThematicInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ThematicInfo) {
            throw new \InvalidArgumentException(sprintf('The myThematics property can only contain items of type \StructType\ThematicInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myThematics[] = $item;
        return $this;
    }
    /**
     * Get myType value
     * @return string|null
     */
    public function getMyType()
    {
        return $this->myType;
    }
    /**
     * Set myType value
     * @param string $myType
     * @return \StructType\BaseEntityInfo
     */
    public function setMyType($myType = null)
    {
        // validation for constraint: string
        if (!is_null($myType) && !is_string($myType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myType, true), gettype($myType)), __LINE__);
        }
        $this->myType = $myType;
        return $this;
    }
}
