<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductInventoryFilter ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductInventoryFilter extends AbstractStructArrayBase
{
    /**
     * The productInventoryFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductInventoryFilter[]
     */
    public $productInventoryFilter;
    /**
     * Constructor method for ArrayOfProductInventoryFilter
     * @uses ArrayOfProductInventoryFilter::setProductInventoryFilter()
     * @param \StructType\ProductInventoryFilter[] $productInventoryFilter
     */
    public function __construct(array $productInventoryFilter = array())
    {
        $this
            ->setProductInventoryFilter($productInventoryFilter);
    }
    /**
     * Get productInventoryFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductInventoryFilter[]|null
     */
    public function getProductInventoryFilter()
    {
        return isset($this->productInventoryFilter) ? $this->productInventoryFilter : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductInventoryFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductInventoryFilter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductInventoryFilterForArrayConstraintsFromSetProductInventoryFilter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductInventoryFilterProductInventoryFilterItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductInventoryFilterProductInventoryFilterItem instanceof \StructType\ProductInventoryFilter) {
                $invalidValues[] = is_object($arrayOfProductInventoryFilterProductInventoryFilterItem) ? get_class($arrayOfProductInventoryFilterProductInventoryFilterItem) : sprintf('%s(%s)', gettype($arrayOfProductInventoryFilterProductInventoryFilterItem), var_export($arrayOfProductInventoryFilterProductInventoryFilterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productInventoryFilter property can only contain items of type \StructType\ProductInventoryFilter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productInventoryFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInventoryFilter[] $productInventoryFilter
     * @return \ArrayType\ArrayOfProductInventoryFilter
     */
    public function setProductInventoryFilter(array $productInventoryFilter = array())
    {
        // validation for constraint: array
        if ('' !== ($productInventoryFilterArrayErrorMessage = self::validateProductInventoryFilterForArrayConstraintsFromSetProductInventoryFilter($productInventoryFilter))) {
            throw new \InvalidArgumentException($productInventoryFilterArrayErrorMessage, __LINE__);
        }
        if (is_null($productInventoryFilter) || (is_array($productInventoryFilter) && empty($productInventoryFilter))) {
            unset($this->productInventoryFilter);
        } else {
            $this->productInventoryFilter = $productInventoryFilter;
        }
        return $this;
    }
    /**
     * Add item to productInventoryFilter value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInventoryFilter $item
     * @return \ArrayType\ArrayOfProductInventoryFilter
     */
    public function addToProductInventoryFilter(\StructType\ProductInventoryFilter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInventoryFilter) {
            throw new \InvalidArgumentException(sprintf('The productInventoryFilter property can only contain items of type \StructType\ProductInventoryFilter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productInventoryFilter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductInventoryFilter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductInventoryFilter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductInventoryFilter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductInventoryFilter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductInventoryFilter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string productInventoryFilter
     */
    public function getAttributeName()
    {
        return 'productInventoryFilter';
    }
}
