<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOptionPeriod ArrayType
 * @subpackage Arrays
 */
class ArrayOfOptionPeriod extends AbstractStructArrayBase
{
    /**
     * The OptionPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OptionPeriod[]
     */
    public $OptionPeriod;
    /**
     * Constructor method for ArrayOfOptionPeriod
     * @uses ArrayOfOptionPeriod::setOptionPeriod()
     * @param \StructType\OptionPeriod[] $optionPeriod
     */
    public function __construct(array $optionPeriod = array())
    {
        $this
            ->setOptionPeriod($optionPeriod);
    }
    /**
     * Get OptionPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OptionPeriod[]|null
     */
    public function getOptionPeriod()
    {
        return isset($this->OptionPeriod) ? $this->OptionPeriod : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOptionPeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptionPeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionPeriodForArrayConstraintsFromSetOptionPeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOptionPeriodOptionPeriodItem) {
            // validation for constraint: itemType
            if (!$arrayOfOptionPeriodOptionPeriodItem instanceof \StructType\OptionPeriod) {
                $invalidValues[] = is_object($arrayOfOptionPeriodOptionPeriodItem) ? get_class($arrayOfOptionPeriodOptionPeriodItem) : sprintf('%s(%s)', gettype($arrayOfOptionPeriodOptionPeriodItem), var_export($arrayOfOptionPeriodOptionPeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OptionPeriod property can only contain items of type \StructType\OptionPeriod, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OptionPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OptionPeriod[] $optionPeriod
     * @return \ArrayType\ArrayOfOptionPeriod
     */
    public function setOptionPeriod(array $optionPeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($optionPeriodArrayErrorMessage = self::validateOptionPeriodForArrayConstraintsFromSetOptionPeriod($optionPeriod))) {
            throw new \InvalidArgumentException($optionPeriodArrayErrorMessage, __LINE__);
        }
        if (is_null($optionPeriod) || (is_array($optionPeriod) && empty($optionPeriod))) {
            unset($this->OptionPeriod);
        } else {
            $this->OptionPeriod = $optionPeriod;
        }
        return $this;
    }
    /**
     * Add item to OptionPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\OptionPeriod $item
     * @return \ArrayType\ArrayOfOptionPeriod
     */
    public function addToOptionPeriod(\StructType\OptionPeriod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OptionPeriod) {
            throw new \InvalidArgumentException(sprintf('The OptionPeriod property can only contain items of type \StructType\OptionPeriod, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OptionPeriod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OptionPeriod|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OptionPeriod|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OptionPeriod|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OptionPeriod|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OptionPeriod|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OptionPeriod
     */
    public function getAttributeName()
    {
        return 'OptionPeriod';
    }
}
