<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for wsMoreInfoSettings StructType
 * @subpackage Structs
 */
class WsMoreInfoSettings extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Language;
    /**
     * The EstablishmentFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WsMoreInfoFilterEstablishment
     */
    public $EstablishmentFilter;
    /**
     * The ProductFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WsMoreInfoFilterProduct
     */
    public $ProductFilter;
    /**
     * Constructor method for wsMoreInfoSettings
     * @uses WsMoreInfoSettings::setLanguage()
     * @uses WsMoreInfoSettings::setEstablishmentFilter()
     * @uses WsMoreInfoSettings::setProductFilter()
     * @param string $language
     * @param \StructType\WsMoreInfoFilterEstablishment $establishmentFilter
     * @param \StructType\WsMoreInfoFilterProduct $productFilter
     */
    public function __construct($language = null, \StructType\WsMoreInfoFilterEstablishment $establishmentFilter = null, \StructType\WsMoreInfoFilterProduct $productFilter = null)
    {
        $this
            ->setLanguage($language)
            ->setEstablishmentFilter($establishmentFilter)
            ->setProductFilter($productFilter);
    }
    /**
     * Get Language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \EnumType\LanguageCode::valueIsValid()
     * @uses \EnumType\LanguageCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\WsMoreInfoSettings
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguageCode::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageCode', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\LanguageCode::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get EstablishmentFilter value
     * @return \StructType\WsMoreInfoFilterEstablishment|null
     */
    public function getEstablishmentFilter()
    {
        return $this->EstablishmentFilter;
    }
    /**
     * Set EstablishmentFilter value
     * @param \StructType\WsMoreInfoFilterEstablishment $establishmentFilter
     * @return \StructType\WsMoreInfoSettings
     */
    public function setEstablishmentFilter(\StructType\WsMoreInfoFilterEstablishment $establishmentFilter = null)
    {
        $this->EstablishmentFilter = $establishmentFilter;
        return $this;
    }
    /**
     * Get ProductFilter value
     * @return \StructType\WsMoreInfoFilterProduct|null
     */
    public function getProductFilter()
    {
        return $this->ProductFilter;
    }
    /**
     * Set ProductFilter value
     * @param \StructType\WsMoreInfoFilterProduct $productFilter
     * @return \StructType\WsMoreInfoSettings
     */
    public function setProductFilter(\StructType\WsMoreInfoFilterProduct $productFilter = null)
    {
        $this->ProductFilter = $productFilter;
        return $this;
    }
}
