<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productShortStayPrice StructType
 * @subpackage Structs
 */
class ProductShortStayPrice extends AbstractStructBase
{
    /**
     * The weekEndOrNot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $weekEndOrNot;
    /**
     * The dayCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dayCount;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * Constructor method for productShortStayPrice
     * @uses ProductShortStayPrice::setWeekEndOrNot()
     * @uses ProductShortStayPrice::setDayCount()
     * @uses ProductShortStayPrice::setPrice()
     * @param string $weekEndOrNot
     * @param int $dayCount
     * @param float $price
     */
    public function __construct($weekEndOrNot = null, $dayCount = null, $price = null)
    {
        $this
            ->setWeekEndOrNot($weekEndOrNot)
            ->setDayCount($dayCount)
            ->setPrice($price);
    }
    /**
     * Get weekEndOrNot value
     * @return string
     */
    public function getWeekEndOrNot()
    {
        return $this->weekEndOrNot;
    }
    /**
     * Set weekEndOrNot value
     * @uses \EnumType\WeekEndOrNotEnum::valueIsValid()
     * @uses \EnumType\WeekEndOrNotEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weekEndOrNot
     * @return \StructType\ProductShortStayPrice
     */
    public function setWeekEndOrNot($weekEndOrNot = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WeekEndOrNotEnum::valueIsValid($weekEndOrNot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WeekEndOrNotEnum', is_array($weekEndOrNot) ? implode(', ', $weekEndOrNot) : var_export($weekEndOrNot, true), implode(', ', \EnumType\WeekEndOrNotEnum::getValidValues())), __LINE__);
        }
        $this->weekEndOrNot = $weekEndOrNot;
        return $this;
    }
    /**
     * Get dayCount value
     * @return int
     */
    public function getDayCount()
    {
        return $this->dayCount;
    }
    /**
     * Set dayCount value
     * @param int $dayCount
     * @return \StructType\ProductShortStayPrice
     */
    public function setDayCount($dayCount = null)
    {
        // validation for constraint: int
        if (!is_null($dayCount) && !(is_int($dayCount) || ctype_digit($dayCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayCount, true), gettype($dayCount)), __LINE__);
        }
        $this->dayCount = $dayCount;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductShortStayPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
}
