<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Allot StructType
 * @subpackage Structs
 */
class Allot extends AbstractStructBase
{
    /**
     * The Np
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Np;
    /**
     * The AllotID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AllotID;
    /**
     * The PeriodeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodeID;
    /**
     * The DateRetrocession
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateRetrocession;
    /**
     * The ProductDistributeurID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDistributeurID;
    /**
     * The Ordre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Ordre;
    /**
     * The BorneDebutIncluse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BorneDebutIncluse;
    /**
     * The BorneFinIncluse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BorneFinIncluse;
    /**
     * The BorneDebutIncluseEtatOpen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BorneDebutIncluseEtatOpen;
    /**
     * The BorneFinIncluseEtatOpen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BorneFinIncluseEtatOpen;
    /**
     * The DistributeurID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributeurID;
    /**
     * The DetailByPeriodList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDetailByPeriod
     */
    public $DetailByPeriodList;
    /**
     * The DetailList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDetail
     */
    public $DetailList;
    /**
     * Constructor method for Allot
     * @uses Allot::setNp()
     * @uses Allot::setAllotID()
     * @uses Allot::setPeriodeID()
     * @uses Allot::setDateRetrocession()
     * @uses Allot::setProductDistributeurID()
     * @uses Allot::setOrdre()
     * @uses Allot::setBorneDebutIncluse()
     * @uses Allot::setBorneFinIncluse()
     * @uses Allot::setBorneDebutIncluseEtatOpen()
     * @uses Allot::setBorneFinIncluseEtatOpen()
     * @uses Allot::setDistributeurID()
     * @uses Allot::setDetailByPeriodList()
     * @uses Allot::setDetailList()
     * @param int $np
     * @param int $allotID
     * @param int $periodeID
     * @param string $dateRetrocession
     * @param int $productDistributeurID
     * @param int $ordre
     * @param string $borneDebutIncluse
     * @param string $borneFinIncluse
     * @param string $borneDebutIncluseEtatOpen
     * @param string $borneFinIncluseEtatOpen
     * @param int $distributeurID
     * @param \ArrayType\ArrayOfDetailByPeriod $detailByPeriodList
     * @param \ArrayType\ArrayOfDetail $detailList
     */
    public function __construct($np = null, $allotID = null, $periodeID = null, $dateRetrocession = null, $productDistributeurID = null, $ordre = null, $borneDebutIncluse = null, $borneFinIncluse = null, $borneDebutIncluseEtatOpen = null, $borneFinIncluseEtatOpen = null, $distributeurID = null, \ArrayType\ArrayOfDetailByPeriod $detailByPeriodList = null, \ArrayType\ArrayOfDetail $detailList = null)
    {
        $this
            ->setNp($np)
            ->setAllotID($allotID)
            ->setPeriodeID($periodeID)
            ->setDateRetrocession($dateRetrocession)
            ->setProductDistributeurID($productDistributeurID)
            ->setOrdre($ordre)
            ->setBorneDebutIncluse($borneDebutIncluse)
            ->setBorneFinIncluse($borneFinIncluse)
            ->setBorneDebutIncluseEtatOpen($borneDebutIncluseEtatOpen)
            ->setBorneFinIncluseEtatOpen($borneFinIncluseEtatOpen)
            ->setDistributeurID($distributeurID)
            ->setDetailByPeriodList($detailByPeriodList)
            ->setDetailList($detailList);
    }
    /**
     * Get Np value
     * @return int
     */
    public function getNp()
    {
        return $this->Np;
    }
    /**
     * Set Np value
     * @param int $np
     * @return \StructType\Allot
     */
    public function setNp($np = null)
    {
        // validation for constraint: int
        if (!is_null($np) && !(is_int($np) || ctype_digit($np))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($np, true), gettype($np)), __LINE__);
        }
        $this->Np = $np;
        return $this;
    }
    /**
     * Get AllotID value
     * @return int
     */
    public function getAllotID()
    {
        return $this->AllotID;
    }
    /**
     * Set AllotID value
     * @param int $allotID
     * @return \StructType\Allot
     */
    public function setAllotID($allotID = null)
    {
        // validation for constraint: int
        if (!is_null($allotID) && !(is_int($allotID) || ctype_digit($allotID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allotID, true), gettype($allotID)), __LINE__);
        }
        $this->AllotID = $allotID;
        return $this;
    }
    /**
     * Get PeriodeID value
     * @return int
     */
    public function getPeriodeID()
    {
        return $this->PeriodeID;
    }
    /**
     * Set PeriodeID value
     * @param int $periodeID
     * @return \StructType\Allot
     */
    public function setPeriodeID($periodeID = null)
    {
        // validation for constraint: int
        if (!is_null($periodeID) && !(is_int($periodeID) || ctype_digit($periodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($periodeID, true), gettype($periodeID)), __LINE__);
        }
        $this->PeriodeID = $periodeID;
        return $this;
    }
    /**
     * Get DateRetrocession value
     * @return string
     */
    public function getDateRetrocession()
    {
        return $this->DateRetrocession;
    }
    /**
     * Set DateRetrocession value
     * @param string $dateRetrocession
     * @return \StructType\Allot
     */
    public function setDateRetrocession($dateRetrocession = null)
    {
        // validation for constraint: string
        if (!is_null($dateRetrocession) && !is_string($dateRetrocession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateRetrocession, true), gettype($dateRetrocession)), __LINE__);
        }
        $this->DateRetrocession = $dateRetrocession;
        return $this;
    }
    /**
     * Get ProductDistributeurID value
     * @return int
     */
    public function getProductDistributeurID()
    {
        return $this->ProductDistributeurID;
    }
    /**
     * Set ProductDistributeurID value
     * @param int $productDistributeurID
     * @return \StructType\Allot
     */
    public function setProductDistributeurID($productDistributeurID = null)
    {
        // validation for constraint: int
        if (!is_null($productDistributeurID) && !(is_int($productDistributeurID) || ctype_digit($productDistributeurID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productDistributeurID, true), gettype($productDistributeurID)), __LINE__);
        }
        $this->ProductDistributeurID = $productDistributeurID;
        return $this;
    }
    /**
     * Get Ordre value
     * @return int
     */
    public function getOrdre()
    {
        return $this->Ordre;
    }
    /**
     * Set Ordre value
     * @param int $ordre
     * @return \StructType\Allot
     */
    public function setOrdre($ordre = null)
    {
        // validation for constraint: int
        if (!is_null($ordre) && !(is_int($ordre) || ctype_digit($ordre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordre, true), gettype($ordre)), __LINE__);
        }
        $this->Ordre = $ordre;
        return $this;
    }
    /**
     * Get BorneDebutIncluse value
     * @return string
     */
    public function getBorneDebutIncluse()
    {
        return $this->BorneDebutIncluse;
    }
    /**
     * Set BorneDebutIncluse value
     * @param string $borneDebutIncluse
     * @return \StructType\Allot
     */
    public function setBorneDebutIncluse($borneDebutIncluse = null)
    {
        // validation for constraint: string
        if (!is_null($borneDebutIncluse) && !is_string($borneDebutIncluse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($borneDebutIncluse, true), gettype($borneDebutIncluse)), __LINE__);
        }
        $this->BorneDebutIncluse = $borneDebutIncluse;
        return $this;
    }
    /**
     * Get BorneFinIncluse value
     * @return string
     */
    public function getBorneFinIncluse()
    {
        return $this->BorneFinIncluse;
    }
    /**
     * Set BorneFinIncluse value
     * @param string $borneFinIncluse
     * @return \StructType\Allot
     */
    public function setBorneFinIncluse($borneFinIncluse = null)
    {
        // validation for constraint: string
        if (!is_null($borneFinIncluse) && !is_string($borneFinIncluse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($borneFinIncluse, true), gettype($borneFinIncluse)), __LINE__);
        }
        $this->BorneFinIncluse = $borneFinIncluse;
        return $this;
    }
    /**
     * Get BorneDebutIncluseEtatOpen value
     * @return string
     */
    public function getBorneDebutIncluseEtatOpen()
    {
        return $this->BorneDebutIncluseEtatOpen;
    }
    /**
     * Set BorneDebutIncluseEtatOpen value
     * @param string $borneDebutIncluseEtatOpen
     * @return \StructType\Allot
     */
    public function setBorneDebutIncluseEtatOpen($borneDebutIncluseEtatOpen = null)
    {
        // validation for constraint: string
        if (!is_null($borneDebutIncluseEtatOpen) && !is_string($borneDebutIncluseEtatOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($borneDebutIncluseEtatOpen, true), gettype($borneDebutIncluseEtatOpen)), __LINE__);
        }
        $this->BorneDebutIncluseEtatOpen = $borneDebutIncluseEtatOpen;
        return $this;
    }
    /**
     * Get BorneFinIncluseEtatOpen value
     * @return string
     */
    public function getBorneFinIncluseEtatOpen()
    {
        return $this->BorneFinIncluseEtatOpen;
    }
    /**
     * Set BorneFinIncluseEtatOpen value
     * @param string $borneFinIncluseEtatOpen
     * @return \StructType\Allot
     */
    public function setBorneFinIncluseEtatOpen($borneFinIncluseEtatOpen = null)
    {
        // validation for constraint: string
        if (!is_null($borneFinIncluseEtatOpen) && !is_string($borneFinIncluseEtatOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($borneFinIncluseEtatOpen, true), gettype($borneFinIncluseEtatOpen)), __LINE__);
        }
        $this->BorneFinIncluseEtatOpen = $borneFinIncluseEtatOpen;
        return $this;
    }
    /**
     * Get DistributeurID value
     * @return int
     */
    public function getDistributeurID()
    {
        return $this->DistributeurID;
    }
    /**
     * Set DistributeurID value
     * @param int $distributeurID
     * @return \StructType\Allot
     */
    public function setDistributeurID($distributeurID = null)
    {
        // validation for constraint: int
        if (!is_null($distributeurID) && !(is_int($distributeurID) || ctype_digit($distributeurID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distributeurID, true), gettype($distributeurID)), __LINE__);
        }
        $this->DistributeurID = $distributeurID;
        return $this;
    }
    /**
     * Get DetailByPeriodList value
     * @return \ArrayType\ArrayOfDetailByPeriod|null
     */
    public function getDetailByPeriodList()
    {
        return $this->DetailByPeriodList;
    }
    /**
     * Set DetailByPeriodList value
     * @param \ArrayType\ArrayOfDetailByPeriod $detailByPeriodList
     * @return \StructType\Allot
     */
    public function setDetailByPeriodList(\ArrayType\ArrayOfDetailByPeriod $detailByPeriodList = null)
    {
        $this->DetailByPeriodList = $detailByPeriodList;
        return $this;
    }
    /**
     * Get DetailList value
     * @return \ArrayType\ArrayOfDetail|null
     */
    public function getDetailList()
    {
        return $this->DetailList;
    }
    /**
     * Set DetailList value
     * @param \ArrayType\ArrayOfDetail $detailList
     * @return \StructType\Allot
     */
    public function setDetailList(\ArrayType\ArrayOfDetail $detailList = null)
    {
        $this->DetailList = $detailList;
        return $this;
    }
}
