<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSUser StructType
 * @subpackage Structs
 */
class WSUser extends AbstractStructBase
{
    /**
     * The idEngine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $idEngine;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * Constructor method for WSUser
     * @uses WSUser::setIdEngine()
     * @uses WSUser::setPassword()
     * @uses WSUser::setUser()
     * @param int $idEngine
     * @param string $password
     * @param string $user
     */
    public function __construct($idEngine = null, $password = null, $user = null)
    {
        $this
            ->setIdEngine($idEngine)
            ->setPassword($password)
            ->setUser($user);
    }
    /**
     * Get idEngine value
     * @return int
     */
    public function getIdEngine()
    {
        return $this->idEngine;
    }
    /**
     * Set idEngine value
     * @param int $idEngine
     * @return \StructType\WSUser
     */
    public function setIdEngine($idEngine = null)
    {
        // validation for constraint: int
        if (!is_null($idEngine) && !(is_int($idEngine) || ctype_digit($idEngine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idEngine, true), gettype($idEngine)), __LINE__);
        }
        $this->idEngine = $idEngine;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\WSUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\WSUser
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
}
