<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialNetworkFilter StructType
 * @subpackage Structs
 */
class SocialNetworkFilter extends AbstractStructBase
{
    /**
     * The EstablishmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstablishmentId;
    /**
     * The ListEnumSocialNetworksName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSocialNetworksName
     */
    public $ListEnumSocialNetworksName;
    /**
     * Constructor method for SocialNetworkFilter
     * @uses SocialNetworkFilter::setEstablishmentId()
     * @uses SocialNetworkFilter::setListEnumSocialNetworksName()
     * @param int $establishmentId
     * @param \ArrayType\ArrayOfSocialNetworksName $listEnumSocialNetworksName
     */
    public function __construct($establishmentId = null, \ArrayType\ArrayOfSocialNetworksName $listEnumSocialNetworksName = null)
    {
        $this
            ->setEstablishmentId($establishmentId)
            ->setListEnumSocialNetworksName($listEnumSocialNetworksName);
    }
    /**
     * Get EstablishmentId value
     * @return int
     */
    public function getEstablishmentId()
    {
        return $this->EstablishmentId;
    }
    /**
     * Set EstablishmentId value
     * @param int $establishmentId
     * @return \StructType\SocialNetworkFilter
     */
    public function setEstablishmentId($establishmentId = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentId) && !(is_int($establishmentId) || ctype_digit($establishmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentId, true), gettype($establishmentId)), __LINE__);
        }
        $this->EstablishmentId = $establishmentId;
        return $this;
    }
    /**
     * Get ListEnumSocialNetworksName value
     * @return \ArrayType\ArrayOfSocialNetworksName|null
     */
    public function getListEnumSocialNetworksName()
    {
        return $this->ListEnumSocialNetworksName;
    }
    /**
     * Set ListEnumSocialNetworksName value
     * @param \ArrayType\ArrayOfSocialNetworksName $listEnumSocialNetworksName
     * @return \StructType\SocialNetworkFilter
     */
    public function setListEnumSocialNetworksName(\ArrayType\ArrayOfSocialNetworksName $listEnumSocialNetworksName = null)
    {
        $this->ListEnumSocialNetworksName = $listEnumSocialNetworksName;
        return $this;
    }
}
