<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastMinute StructType
 * @subpackage Structs
 */
class LastMinute extends AbstractStructBase
{
    /**
     * The nbSolutions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nbSolutions;
    /**
     * The IsCampaignActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsCampaignActive;
    /**
     * The argumentForUrlKml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $argumentForUrlKml;
    /**
     * The solution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Solution
     */
    public $solution;
    /**
     * The starsList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfStars
     */
    public $starsList;
    /**
     * The countryList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCountry
     */
    public $countryList;
    /**
     * The administrativeZone1List
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAdministrativeZone1
     */
    public $administrativeZone1List;
    /**
     * The subTypeProductList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSubTypeProduct
     */
    public $subTypeProductList;
    /**
     * Constructor method for LastMinute
     * @uses LastMinute::setNbSolutions()
     * @uses LastMinute::setIsCampaignActive()
     * @uses LastMinute::setArgumentForUrlKml()
     * @uses LastMinute::setSolution()
     * @uses LastMinute::setStarsList()
     * @uses LastMinute::setCountryList()
     * @uses LastMinute::setAdministrativeZone1List()
     * @uses LastMinute::setSubTypeProductList()
     * @param int $nbSolutions
     * @param bool $isCampaignActive
     * @param string $argumentForUrlKml
     * @param \StructType\Solution $solution
     * @param \ArrayType\ArrayOfStars $starsList
     * @param \ArrayType\ArrayOfCountry $countryList
     * @param \ArrayType\ArrayOfAdministrativeZone1 $administrativeZone1List
     * @param \ArrayType\ArrayOfSubTypeProduct $subTypeProductList
     */
    public function __construct($nbSolutions = null, $isCampaignActive = null, $argumentForUrlKml = null, \StructType\Solution $solution = null, \ArrayType\ArrayOfStars $starsList = null, \ArrayType\ArrayOfCountry $countryList = null, \ArrayType\ArrayOfAdministrativeZone1 $administrativeZone1List = null, \ArrayType\ArrayOfSubTypeProduct $subTypeProductList = null)
    {
        $this
            ->setNbSolutions($nbSolutions)
            ->setIsCampaignActive($isCampaignActive)
            ->setArgumentForUrlKml($argumentForUrlKml)
            ->setSolution($solution)
            ->setStarsList($starsList)
            ->setCountryList($countryList)
            ->setAdministrativeZone1List($administrativeZone1List)
            ->setSubTypeProductList($subTypeProductList);
    }
    /**
     * Get nbSolutions value
     * @return int
     */
    public function getNbSolutions()
    {
        return $this->nbSolutions;
    }
    /**
     * Set nbSolutions value
     * @param int $nbSolutions
     * @return \StructType\LastMinute
     */
    public function setNbSolutions($nbSolutions = null)
    {
        // validation for constraint: int
        if (!is_null($nbSolutions) && !(is_int($nbSolutions) || ctype_digit($nbSolutions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbSolutions, true), gettype($nbSolutions)), __LINE__);
        }
        $this->nbSolutions = $nbSolutions;
        return $this;
    }
    /**
     * Get IsCampaignActive value
     * @return bool
     */
    public function getIsCampaignActive()
    {
        return $this->IsCampaignActive;
    }
    /**
     * Set IsCampaignActive value
     * @param bool $isCampaignActive
     * @return \StructType\LastMinute
     */
    public function setIsCampaignActive($isCampaignActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCampaignActive) && !is_bool($isCampaignActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCampaignActive, true), gettype($isCampaignActive)), __LINE__);
        }
        $this->IsCampaignActive = $isCampaignActive;
        return $this;
    }
    /**
     * Get argumentForUrlKml value
     * @return string|null
     */
    public function getArgumentForUrlKml()
    {
        return $this->argumentForUrlKml;
    }
    /**
     * Set argumentForUrlKml value
     * @param string $argumentForUrlKml
     * @return \StructType\LastMinute
     */
    public function setArgumentForUrlKml($argumentForUrlKml = null)
    {
        // validation for constraint: string
        if (!is_null($argumentForUrlKml) && !is_string($argumentForUrlKml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($argumentForUrlKml, true), gettype($argumentForUrlKml)), __LINE__);
        }
        $this->argumentForUrlKml = $argumentForUrlKml;
        return $this;
    }
    /**
     * Get solution value
     * @return \StructType\Solution|null
     */
    public function getSolution()
    {
        return $this->solution;
    }
    /**
     * Set solution value
     * @param \StructType\Solution $solution
     * @return \StructType\LastMinute
     */
    public function setSolution(\StructType\Solution $solution = null)
    {
        $this->solution = $solution;
        return $this;
    }
    /**
     * Get starsList value
     * @return \ArrayType\ArrayOfStars|null
     */
    public function getStarsList()
    {
        return $this->starsList;
    }
    /**
     * Set starsList value
     * @param \ArrayType\ArrayOfStars $starsList
     * @return \StructType\LastMinute
     */
    public function setStarsList(\ArrayType\ArrayOfStars $starsList = null)
    {
        $this->starsList = $starsList;
        return $this;
    }
    /**
     * Get countryList value
     * @return \ArrayType\ArrayOfCountry|null
     */
    public function getCountryList()
    {
        return $this->countryList;
    }
    /**
     * Set countryList value
     * @param \ArrayType\ArrayOfCountry $countryList
     * @return \StructType\LastMinute
     */
    public function setCountryList(\ArrayType\ArrayOfCountry $countryList = null)
    {
        $this->countryList = $countryList;
        return $this;
    }
    /**
     * Get administrativeZone1List value
     * @return \ArrayType\ArrayOfAdministrativeZone1|null
     */
    public function getAdministrativeZone1List()
    {
        return $this->administrativeZone1List;
    }
    /**
     * Set administrativeZone1List value
     * @param \ArrayType\ArrayOfAdministrativeZone1 $administrativeZone1List
     * @return \StructType\LastMinute
     */
    public function setAdministrativeZone1List(\ArrayType\ArrayOfAdministrativeZone1 $administrativeZone1List = null)
    {
        $this->administrativeZone1List = $administrativeZone1List;
        return $this;
    }
    /**
     * Get subTypeProductList value
     * @return \ArrayType\ArrayOfSubTypeProduct|null
     */
    public function getSubTypeProductList()
    {
        return $this->subTypeProductList;
    }
    /**
     * Set subTypeProductList value
     * @param \ArrayType\ArrayOfSubTypeProduct $subTypeProductList
     * @return \StructType\LastMinute
     */
    public function setSubTypeProductList(\ArrayType\ArrayOfSubTypeProduct $subTypeProductList = null)
    {
        $this->subTypeProductList = $subTypeProductList;
        return $this;
    }
}
