<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAbandonementCart StructType
 * @subpackage Structs
 */
class GetAbandonementCart extends AbstractStructBase
{
    /**
     * The abandonementCartGuid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $abandonementCartGuid;
    /**
     * The establishementId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $establishementId;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WSUser
     */
    public $User;
    /**
     * Constructor method for GetAbandonementCart
     * @uses GetAbandonementCart::setAbandonementCartGuid()
     * @uses GetAbandonementCart::setEstablishementId()
     * @uses GetAbandonementCart::setUser()
     * @param string $abandonementCartGuid
     * @param int $establishementId
     * @param \StructType\WSUser $user
     */
    public function __construct($abandonementCartGuid = null, $establishementId = null, \StructType\WSUser $user = null)
    {
        $this
            ->setAbandonementCartGuid($abandonementCartGuid)
            ->setEstablishementId($establishementId)
            ->setUser($user);
    }
    /**
     * Get abandonementCartGuid value
     * @return string
     */
    public function getAbandonementCartGuid()
    {
        return $this->abandonementCartGuid;
    }
    /**
     * Set abandonementCartGuid value
     * @param string $abandonementCartGuid
     * @return \StructType\GetAbandonementCart
     */
    public function setAbandonementCartGuid($abandonementCartGuid = null)
    {
        // validation for constraint: string
        if (!is_null($abandonementCartGuid) && !is_string($abandonementCartGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abandonementCartGuid, true), gettype($abandonementCartGuid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($abandonementCartGuid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $abandonementCartGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($abandonementCartGuid, true)), __LINE__);
        }
        $this->abandonementCartGuid = $abandonementCartGuid;
        return $this;
    }
    /**
     * Get establishementId value
     * @return int
     */
    public function getEstablishementId()
    {
        return $this->establishementId;
    }
    /**
     * Set establishementId value
     * @param int $establishementId
     * @return \StructType\GetAbandonementCart
     */
    public function setEstablishementId($establishementId = null)
    {
        // validation for constraint: int
        if (!is_null($establishementId) && !(is_int($establishementId) || ctype_digit($establishementId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishementId, true), gettype($establishementId)), __LINE__);
        }
        $this->establishementId = $establishementId;
        return $this;
    }
    /**
     * Get User value
     * @return \StructType\WSUser|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \StructType\WSUser $user
     * @return \StructType\GetAbandonementCart
     */
    public function setUser(\StructType\WSUser $user = null)
    {
        $this->User = $user;
        return $this;
    }
}
