<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductType ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductType extends AbstractStructArrayBase
{
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ProductType;
    /**
     * Constructor method for ArrayOfProductType
     * @uses ArrayOfProductType::setProductType()
     * @param string[] $productType
     */
    public function __construct(array $productType = array())
    {
        $this
            ->setProductType($productType);
    }
    /**
     * Get ProductType value
     * @return string[]|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * This method is responsible for validating the values passed to the setProductType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductTypeForArrayConstraintsFromSetProductType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductTypeProductTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ProductType::valueIsValid($arrayOfProductTypeProductTypeItem)) {
                $invalidValues[] = is_object($arrayOfProductTypeProductTypeItem) ? get_class($arrayOfProductTypeProductTypeItem) : sprintf('%s(%s)', gettype($arrayOfProductTypeProductTypeItem), var_export($arrayOfProductTypeProductTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ProductType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $productType
     * @return \ArrayType\ArrayOfProductType
     */
    public function setProductType(array $productType = array())
    {
        // validation for constraint: array
        if ('' !== ($productTypeArrayErrorMessage = self::validateProductTypeForArrayConstraintsFromSetProductType($productType))) {
            throw new \InvalidArgumentException($productTypeArrayErrorMessage, __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Add item to ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfProductType
     */
    public function addToProductType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\ProductType::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfProductType
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductType
     */
    public function getAttributeName()
    {
        return 'ProductType';
    }
}
