<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPicture ArrayType
 * @subpackage Arrays
 */
class ArrayOfPicture extends AbstractStructArrayBase
{
    /**
     * The picture
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Picture[]
     */
    public $picture;
    /**
     * Constructor method for ArrayOfPicture
     * @uses ArrayOfPicture::setPicture()
     * @param \StructType\Picture[] $picture
     */
    public function __construct(array $picture = array())
    {
        $this
            ->setPicture($picture);
    }
    /**
     * Get picture value
     * @return \StructType\Picture[]|null
     */
    public function getPicture()
    {
        return $this->picture;
    }
    /**
     * This method is responsible for validating the values passed to the setPicture method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPicture method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePictureForArrayConstraintsFromSetPicture(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPicturePictureItem) {
            // validation for constraint: itemType
            if (!$arrayOfPicturePictureItem instanceof \StructType\Picture) {
                $invalidValues[] = is_object($arrayOfPicturePictureItem) ? get_class($arrayOfPicturePictureItem) : sprintf('%s(%s)', gettype($arrayOfPicturePictureItem), var_export($arrayOfPicturePictureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The picture property can only contain items of type \StructType\Picture, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set picture value
     * @throws \InvalidArgumentException
     * @param \StructType\Picture[] $picture
     * @return \ArrayType\ArrayOfPicture
     */
    public function setPicture(array $picture = array())
    {
        // validation for constraint: array
        if ('' !== ($pictureArrayErrorMessage = self::validatePictureForArrayConstraintsFromSetPicture($picture))) {
            throw new \InvalidArgumentException($pictureArrayErrorMessage, __LINE__);
        }
        $this->picture = $picture;
        return $this;
    }
    /**
     * Add item to picture value
     * @throws \InvalidArgumentException
     * @param \StructType\Picture $item
     * @return \ArrayType\ArrayOfPicture
     */
    public function addToPicture(\StructType\Picture $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Picture) {
            throw new \InvalidArgumentException(sprintf('The picture property can only contain items of type \StructType\Picture, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->picture[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Picture|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Picture|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Picture|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Picture|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Picture|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string picture
     */
    public function getAttributeName()
    {
        return 'picture';
    }
}
