<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productSpecialOffer StructType
 * @subpackage Structs
 */
class ProductSpecialOffer extends AbstractStructBase
{
    /**
     * The OS_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OS_id;
    /**
     * The SpecialOfferId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SpecialOfferId;
    /**
     * The OS_price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OS_price;
    /**
     * The OS_offeredOptionCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OS_offeredOptionCount;
    /**
     * The OS_technicName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_technicName;
    /**
     * The OS_genericDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_genericDescription;
    /**
     * The OS_shortDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_shortDescription;
    /**
     * The OS_tagDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_tagDescription;
    /**
     * The OS_longDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_longDescription;
    /**
     * The OS_TagDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_TagDuration;
    /**
     * The OS_TagAvailability
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_TagAvailability;
    /**
     * The OS_UrlBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_UrlBooking;
    /**
     * The OS_type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_type;
    /**
     * The OS_uniqueIdentifierSpecialOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_uniqueIdentifierSpecialOffer;
    /**
     * Constructor method for productSpecialOffer
     * @uses ProductSpecialOffer::setOS_id()
     * @uses ProductSpecialOffer::setSpecialOfferId()
     * @uses ProductSpecialOffer::setOS_price()
     * @uses ProductSpecialOffer::setOS_offeredOptionCount()
     * @uses ProductSpecialOffer::setOS_technicName()
     * @uses ProductSpecialOffer::setOS_genericDescription()
     * @uses ProductSpecialOffer::setOS_shortDescription()
     * @uses ProductSpecialOffer::setOS_tagDescription()
     * @uses ProductSpecialOffer::setOS_longDescription()
     * @uses ProductSpecialOffer::setOS_TagDuration()
     * @uses ProductSpecialOffer::setOS_TagAvailability()
     * @uses ProductSpecialOffer::setOS_UrlBooking()
     * @uses ProductSpecialOffer::setOS_type()
     * @uses ProductSpecialOffer::setOS_uniqueIdentifierSpecialOffer()
     * @param int $oS_id
     * @param int $specialOfferId
     * @param float $oS_price
     * @param int $oS_offeredOptionCount
     * @param string $oS_technicName
     * @param string $oS_genericDescription
     * @param string $oS_shortDescription
     * @param string $oS_tagDescription
     * @param string $oS_longDescription
     * @param string $oS_TagDuration
     * @param string $oS_TagAvailability
     * @param string $oS_UrlBooking
     * @param string $oS_type
     * @param string $oS_uniqueIdentifierSpecialOffer
     */
    public function __construct($oS_id = null, $specialOfferId = null, $oS_price = null, $oS_offeredOptionCount = null, $oS_technicName = null, $oS_genericDescription = null, $oS_shortDescription = null, $oS_tagDescription = null, $oS_longDescription = null, $oS_TagDuration = null, $oS_TagAvailability = null, $oS_UrlBooking = null, $oS_type = null, $oS_uniqueIdentifierSpecialOffer = null)
    {
        $this
            ->setOS_id($oS_id)
            ->setSpecialOfferId($specialOfferId)
            ->setOS_price($oS_price)
            ->setOS_offeredOptionCount($oS_offeredOptionCount)
            ->setOS_technicName($oS_technicName)
            ->setOS_genericDescription($oS_genericDescription)
            ->setOS_shortDescription($oS_shortDescription)
            ->setOS_tagDescription($oS_tagDescription)
            ->setOS_longDescription($oS_longDescription)
            ->setOS_TagDuration($oS_TagDuration)
            ->setOS_TagAvailability($oS_TagAvailability)
            ->setOS_UrlBooking($oS_UrlBooking)
            ->setOS_type($oS_type)
            ->setOS_uniqueIdentifierSpecialOffer($oS_uniqueIdentifierSpecialOffer);
    }
    /**
     * Get OS_id value
     * @return int
     */
    public function getOS_id()
    {
        return $this->OS_id;
    }
    /**
     * Set OS_id value
     * @param int $oS_id
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_id($oS_id = null)
    {
        // validation for constraint: int
        if (!is_null($oS_id) && !(is_int($oS_id) || ctype_digit($oS_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oS_id, true), gettype($oS_id)), __LINE__);
        }
        $this->OS_id = $oS_id;
        return $this;
    }
    /**
     * Get SpecialOfferId value
     * @return int
     */
    public function getSpecialOfferId()
    {
        return $this->SpecialOfferId;
    }
    /**
     * Set SpecialOfferId value
     * @param int $specialOfferId
     * @return \StructType\ProductSpecialOffer
     */
    public function setSpecialOfferId($specialOfferId = null)
    {
        // validation for constraint: int
        if (!is_null($specialOfferId) && !(is_int($specialOfferId) || ctype_digit($specialOfferId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($specialOfferId, true), gettype($specialOfferId)), __LINE__);
        }
        $this->SpecialOfferId = $specialOfferId;
        return $this;
    }
    /**
     * Get OS_price value
     * @return float
     */
    public function getOS_price()
    {
        return $this->OS_price;
    }
    /**
     * Set OS_price value
     * @param float $oS_price
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_price($oS_price = null)
    {
        // validation for constraint: float
        if (!is_null($oS_price) && !(is_float($oS_price) || is_numeric($oS_price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oS_price, true), gettype($oS_price)), __LINE__);
        }
        $this->OS_price = $oS_price;
        return $this;
    }
    /**
     * Get OS_offeredOptionCount value
     * @return int
     */
    public function getOS_offeredOptionCount()
    {
        return $this->OS_offeredOptionCount;
    }
    /**
     * Set OS_offeredOptionCount value
     * @param int $oS_offeredOptionCount
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_offeredOptionCount($oS_offeredOptionCount = null)
    {
        // validation for constraint: int
        if (!is_null($oS_offeredOptionCount) && !(is_int($oS_offeredOptionCount) || ctype_digit($oS_offeredOptionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oS_offeredOptionCount, true), gettype($oS_offeredOptionCount)), __LINE__);
        }
        $this->OS_offeredOptionCount = $oS_offeredOptionCount;
        return $this;
    }
    /**
     * Get OS_technicName value
     * @return string|null
     */
    public function getOS_technicName()
    {
        return $this->OS_technicName;
    }
    /**
     * Set OS_technicName value
     * @param string $oS_technicName
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_technicName($oS_technicName = null)
    {
        // validation for constraint: string
        if (!is_null($oS_technicName) && !is_string($oS_technicName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_technicName, true), gettype($oS_technicName)), __LINE__);
        }
        $this->OS_technicName = $oS_technicName;
        return $this;
    }
    /**
     * Get OS_genericDescription value
     * @return string|null
     */
    public function getOS_genericDescription()
    {
        return $this->OS_genericDescription;
    }
    /**
     * Set OS_genericDescription value
     * @param string $oS_genericDescription
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_genericDescription($oS_genericDescription = null)
    {
        // validation for constraint: string
        if (!is_null($oS_genericDescription) && !is_string($oS_genericDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_genericDescription, true), gettype($oS_genericDescription)), __LINE__);
        }
        $this->OS_genericDescription = $oS_genericDescription;
        return $this;
    }
    /**
     * Get OS_shortDescription value
     * @return string|null
     */
    public function getOS_shortDescription()
    {
        return $this->OS_shortDescription;
    }
    /**
     * Set OS_shortDescription value
     * @param string $oS_shortDescription
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_shortDescription($oS_shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($oS_shortDescription) && !is_string($oS_shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_shortDescription, true), gettype($oS_shortDescription)), __LINE__);
        }
        $this->OS_shortDescription = $oS_shortDescription;
        return $this;
    }
    /**
     * Get OS_tagDescription value
     * @return string|null
     */
    public function getOS_tagDescription()
    {
        return $this->OS_tagDescription;
    }
    /**
     * Set OS_tagDescription value
     * @param string $oS_tagDescription
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_tagDescription($oS_tagDescription = null)
    {
        // validation for constraint: string
        if (!is_null($oS_tagDescription) && !is_string($oS_tagDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_tagDescription, true), gettype($oS_tagDescription)), __LINE__);
        }
        $this->OS_tagDescription = $oS_tagDescription;
        return $this;
    }
    /**
     * Get OS_longDescription value
     * @return string|null
     */
    public function getOS_longDescription()
    {
        return $this->OS_longDescription;
    }
    /**
     * Set OS_longDescription value
     * @param string $oS_longDescription
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_longDescription($oS_longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($oS_longDescription) && !is_string($oS_longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_longDescription, true), gettype($oS_longDescription)), __LINE__);
        }
        $this->OS_longDescription = $oS_longDescription;
        return $this;
    }
    /**
     * Get OS_TagDuration value
     * @return string|null
     */
    public function getOS_TagDuration()
    {
        return $this->OS_TagDuration;
    }
    /**
     * Set OS_TagDuration value
     * @param string $oS_TagDuration
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_TagDuration($oS_TagDuration = null)
    {
        // validation for constraint: string
        if (!is_null($oS_TagDuration) && !is_string($oS_TagDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_TagDuration, true), gettype($oS_TagDuration)), __LINE__);
        }
        $this->OS_TagDuration = $oS_TagDuration;
        return $this;
    }
    /**
     * Get OS_TagAvailability value
     * @return string|null
     */
    public function getOS_TagAvailability()
    {
        return $this->OS_TagAvailability;
    }
    /**
     * Set OS_TagAvailability value
     * @param string $oS_TagAvailability
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_TagAvailability($oS_TagAvailability = null)
    {
        // validation for constraint: string
        if (!is_null($oS_TagAvailability) && !is_string($oS_TagAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_TagAvailability, true), gettype($oS_TagAvailability)), __LINE__);
        }
        $this->OS_TagAvailability = $oS_TagAvailability;
        return $this;
    }
    /**
     * Get OS_UrlBooking value
     * @return string|null
     */
    public function getOS_UrlBooking()
    {
        return $this->OS_UrlBooking;
    }
    /**
     * Set OS_UrlBooking value
     * @param string $oS_UrlBooking
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_UrlBooking($oS_UrlBooking = null)
    {
        // validation for constraint: string
        if (!is_null($oS_UrlBooking) && !is_string($oS_UrlBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_UrlBooking, true), gettype($oS_UrlBooking)), __LINE__);
        }
        $this->OS_UrlBooking = $oS_UrlBooking;
        return $this;
    }
    /**
     * Get OS_type value
     * @return string|null
     */
    public function getOS_type()
    {
        return $this->OS_type;
    }
    /**
     * Set OS_type value
     * @param string $oS_type
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_type($oS_type = null)
    {
        // validation for constraint: string
        if (!is_null($oS_type) && !is_string($oS_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_type, true), gettype($oS_type)), __LINE__);
        }
        $this->OS_type = $oS_type;
        return $this;
    }
    /**
     * Get OS_uniqueIdentifierSpecialOffer value
     * @return string|null
     */
    public function getOS_uniqueIdentifierSpecialOffer()
    {
        return $this->OS_uniqueIdentifierSpecialOffer;
    }
    /**
     * Set OS_uniqueIdentifierSpecialOffer value
     * @param string $oS_uniqueIdentifierSpecialOffer
     * @return \StructType\ProductSpecialOffer
     */
    public function setOS_uniqueIdentifierSpecialOffer($oS_uniqueIdentifierSpecialOffer = null)
    {
        // validation for constraint: string
        if (!is_null($oS_uniqueIdentifierSpecialOffer) && !is_string($oS_uniqueIdentifierSpecialOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_uniqueIdentifierSpecialOffer, true), gettype($oS_uniqueIdentifierSpecialOffer)), __LINE__);
        }
        $this->OS_uniqueIdentifierSpecialOffer = $oS_uniqueIdentifierSpecialOffer;
        return $this;
    }
}
