<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferAccount StructType
 * @subpackage Structs
 */
class OfferAccount extends AbstractStructBase
{
    /**
     * The AccountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AccountAmount;
    /**
     * The UniteAcompte
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UniteAcompte;
    /**
     * Constructor method for OfferAccount
     * @uses OfferAccount::setAccountAmount()
     * @uses OfferAccount::setUniteAcompte()
     * @param float $accountAmount
     * @param string $uniteAcompte
     */
    public function __construct($accountAmount = null, $uniteAcompte = null)
    {
        $this
            ->setAccountAmount($accountAmount)
            ->setUniteAcompte($uniteAcompte);
    }
    /**
     * Get AccountAmount value
     * @return float
     */
    public function getAccountAmount()
    {
        return $this->AccountAmount;
    }
    /**
     * Set AccountAmount value
     * @param float $accountAmount
     * @return \StructType\OfferAccount
     */
    public function setAccountAmount($accountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($accountAmount) && !(is_float($accountAmount) || is_numeric($accountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accountAmount, true), gettype($accountAmount)), __LINE__);
        }
        $this->AccountAmount = $accountAmount;
        return $this;
    }
    /**
     * Get UniteAcompte value
     * @return string
     */
    public function getUniteAcompte()
    {
        return $this->UniteAcompte;
    }
    /**
     * Set UniteAcompte value
     * @uses \EnumType\UniteAcompte::valueIsValid()
     * @uses \EnumType\UniteAcompte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uniteAcompte
     * @return \StructType\OfferAccount
     */
    public function setUniteAcompte($uniteAcompte = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UniteAcompte::valueIsValid($uniteAcompte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UniteAcompte', is_array($uniteAcompte) ? implode(', ', $uniteAcompte) : var_export($uniteAcompte, true), implode(', ', \EnumType\UniteAcompte::getValidValues())), __LINE__);
        }
        $this->UniteAcompte = $uniteAcompte;
        return $this;
    }
}
