<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthFromToValue StructType
 * @subpackage Structs
 */
class MonthFromToValue extends ItemTypeValue
{
    /**
     * The monthBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $monthBegin;
    /**
     * The monthEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $monthEnd;
    /**
     * Constructor method for MonthFromToValue
     * @uses MonthFromToValue::setMonthBegin()
     * @uses MonthFromToValue::setMonthEnd()
     * @param int $monthBegin
     * @param int $monthEnd
     */
    public function __construct($monthBegin = null, $monthEnd = null)
    {
        $this
            ->setMonthBegin($monthBegin)
            ->setMonthEnd($monthEnd);
    }
    /**
     * Get monthBegin value
     * @return int
     */
    public function getMonthBegin()
    {
        return $this->monthBegin;
    }
    /**
     * Set monthBegin value
     * @param int $monthBegin
     * @return \StructType\MonthFromToValue
     */
    public function setMonthBegin($monthBegin = null)
    {
        // validation for constraint: int
        if (!is_null($monthBegin) && !(is_int($monthBegin) || ctype_digit($monthBegin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthBegin, true), gettype($monthBegin)), __LINE__);
        }
        $this->monthBegin = $monthBegin;
        return $this;
    }
    /**
     * Get monthEnd value
     * @return int
     */
    public function getMonthEnd()
    {
        return $this->monthEnd;
    }
    /**
     * Set monthEnd value
     * @param int $monthEnd
     * @return \StructType\MonthFromToValue
     */
    public function setMonthEnd($monthEnd = null)
    {
        // validation for constraint: int
        if (!is_null($monthEnd) && !(is_int($monthEnd) || ctype_digit($monthEnd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthEnd, true), gettype($monthEnd)), __LINE__);
        }
        $this->monthEnd = $monthEnd;
        return $this;
    }
}
