<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActiveValue StructType
 * @subpackage Structs
 */
class ActiveValue extends ItemTypeValue
{
    /**
     * The isActif
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isActif;
    /**
     * Constructor method for ActiveValue
     * @uses ActiveValue::setIsActif()
     * @param bool $isActif
     */
    public function __construct($isActif = null)
    {
        $this
            ->setIsActif($isActif);
    }
    /**
     * Get isActif value
     * @return bool
     */
    public function getIsActif()
    {
        return $this->isActif;
    }
    /**
     * Set isActif value
     * @param bool $isActif
     * @return \StructType\ActiveValue
     */
    public function setIsActif($isActif = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActif) && !is_bool($isActif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActif, true), gettype($isActif)), __LINE__);
        }
        $this->isActif = $isActif;
        return $this;
    }
}
