<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.secureholiday.net/v3/engine.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.secureholiday.net/v3/engine.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetLastMinuteOffers operation/method
 */
if ($get->GetLastMinuteOffers(new \StructType\GetLastMinuteOffers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductsPlanning operation/method
 */
if ($get->GetProductsPlanning(new \StructType\GetProductsPlanning()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStartingFromPriceList operation/method
 */
if ($get->GetStartingFromPriceList(new \StructType\GetStartingFromPriceList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAbandonementCart operation/method
 */
if ($get->GetAbandonementCart(new \StructType\GetAbandonementCart()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStartingFromPriceFile operation/method
 */
if ($get->GetStartingFromPriceFile(new \StructType\GetStartingFromPriceFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInjectedOffers operation/method
 */
if ($get->GetInjectedOffers(new \StructType\GetInjectedOffers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllotmentsInfo operation/method
 */
if ($get->GetAllotmentsInfo(new \StructType\GetAllotmentsInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEstablishmentSocialNetworks operation/method
 */
if ($get->GetEstablishmentSocialNetworks(new \StructType\GetEstablishmentSocialNetworks()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuote operation/method
 */
if ($get->GetQuote(new \StructType\GetQuote()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEntityTypeAttributes operation/method
 */
if ($get->getEntityTypeAttributes(new \StructType\GetEntityTypeAttributes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEstablishmentInformations operation/method
 */
if ($get->GetEstablishmentInformations(new \StructType\GetEstablishmentInformations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEstablishmentPhotos operation/method
 */
if ($get->GetEstablishmentPhotos(new \StructType\GetEstablishmentPhotos()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetActiveKeysFromEngine operation/method
 */
if ($get->GetActiveKeysFromEngine(new \StructType\GetActiveKeysFromEngine()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCatalogue operation/method
 */
if ($get->GetCatalogue(new \StructType\GetCatalogue()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveAbandonementCart operation/method
 */
if ($save->SaveAbandonementCart(new \StructType\SaveAbandonementCart()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Has ServiceType
 */
$has = new \ServiceType\Has($options);
/**
 * Sample call for HasAccessAbandonementCart operation/method
 */
if ($has->HasAccessAbandonementCart(new \StructType\HasAccessAbandonementCart()) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for SearchQuote operation/method
 */
if ($search->SearchQuote(new \StructType\SearchQuote()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckQuote operation/method
 */
if ($check->CheckQuote(new \StructType\CheckQuote()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
