<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TunnelStay StructType
 * @subpackage Structs
 */
class TunnelStay extends AbstractStructBase
{
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductId;
    /**
     * The GridId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GridId;
    /**
     * The PersonIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonIncluded;
    /**
     * The PersonMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonMin;
    /**
     * The PersonMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonMax;
    /**
     * The StayBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StayBegin;
    /**
     * The StayEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StayEnd;
    /**
     * The GetStayNightDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GetStayNightDuration;
    /**
     * The ProductChaineTraduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductChaineTraduction;
    /**
     * The ProductLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductLabel;
    /**
     * The GridModelChaineTraduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GridModelChaineTraduction;
    /**
     * The GridLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GridLabel;
    /**
     * The EstablishmentCommentary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstablishmentCommentary;
    /**
     * Constructor method for TunnelStay
     * @uses TunnelStay::setProductId()
     * @uses TunnelStay::setGridId()
     * @uses TunnelStay::setPersonIncluded()
     * @uses TunnelStay::setPersonMin()
     * @uses TunnelStay::setPersonMax()
     * @uses TunnelStay::setStayBegin()
     * @uses TunnelStay::setStayEnd()
     * @uses TunnelStay::setGetStayNightDuration()
     * @uses TunnelStay::setProductChaineTraduction()
     * @uses TunnelStay::setProductLabel()
     * @uses TunnelStay::setGridModelChaineTraduction()
     * @uses TunnelStay::setGridLabel()
     * @uses TunnelStay::setEstablishmentCommentary()
     * @param int $productId
     * @param int $gridId
     * @param int $personIncluded
     * @param int $personMin
     * @param int $personMax
     * @param string $stayBegin
     * @param string $stayEnd
     * @param int $getStayNightDuration
     * @param string $productChaineTraduction
     * @param string $productLabel
     * @param string $gridModelChaineTraduction
     * @param string $gridLabel
     * @param string $establishmentCommentary
     */
    public function __construct($productId = null, $gridId = null, $personIncluded = null, $personMin = null, $personMax = null, $stayBegin = null, $stayEnd = null, $getStayNightDuration = null, $productChaineTraduction = null, $productLabel = null, $gridModelChaineTraduction = null, $gridLabel = null, $establishmentCommentary = null)
    {
        $this
            ->setProductId($productId)
            ->setGridId($gridId)
            ->setPersonIncluded($personIncluded)
            ->setPersonMin($personMin)
            ->setPersonMax($personMax)
            ->setStayBegin($stayBegin)
            ->setStayEnd($stayEnd)
            ->setGetStayNightDuration($getStayNightDuration)
            ->setProductChaineTraduction($productChaineTraduction)
            ->setProductLabel($productLabel)
            ->setGridModelChaineTraduction($gridModelChaineTraduction)
            ->setGridLabel($gridLabel)
            ->setEstablishmentCommentary($establishmentCommentary);
    }
    /**
     * Get ProductId value
     * @return int
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\TunnelStay
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get GridId value
     * @return int
     */
    public function getGridId()
    {
        return $this->GridId;
    }
    /**
     * Set GridId value
     * @param int $gridId
     * @return \StructType\TunnelStay
     */
    public function setGridId($gridId = null)
    {
        // validation for constraint: int
        if (!is_null($gridId) && !(is_int($gridId) || ctype_digit($gridId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gridId, true), gettype($gridId)), __LINE__);
        }
        $this->GridId = $gridId;
        return $this;
    }
    /**
     * Get PersonIncluded value
     * @return int
     */
    public function getPersonIncluded()
    {
        return $this->PersonIncluded;
    }
    /**
     * Set PersonIncluded value
     * @param int $personIncluded
     * @return \StructType\TunnelStay
     */
    public function setPersonIncluded($personIncluded = null)
    {
        // validation for constraint: int
        if (!is_null($personIncluded) && !(is_int($personIncluded) || ctype_digit($personIncluded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personIncluded, true), gettype($personIncluded)), __LINE__);
        }
        $this->PersonIncluded = $personIncluded;
        return $this;
    }
    /**
     * Get PersonMin value
     * @return int
     */
    public function getPersonMin()
    {
        return $this->PersonMin;
    }
    /**
     * Set PersonMin value
     * @param int $personMin
     * @return \StructType\TunnelStay
     */
    public function setPersonMin($personMin = null)
    {
        // validation for constraint: int
        if (!is_null($personMin) && !(is_int($personMin) || ctype_digit($personMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personMin, true), gettype($personMin)), __LINE__);
        }
        $this->PersonMin = $personMin;
        return $this;
    }
    /**
     * Get PersonMax value
     * @return int
     */
    public function getPersonMax()
    {
        return $this->PersonMax;
    }
    /**
     * Set PersonMax value
     * @param int $personMax
     * @return \StructType\TunnelStay
     */
    public function setPersonMax($personMax = null)
    {
        // validation for constraint: int
        if (!is_null($personMax) && !(is_int($personMax) || ctype_digit($personMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personMax, true), gettype($personMax)), __LINE__);
        }
        $this->PersonMax = $personMax;
        return $this;
    }
    /**
     * Get StayBegin value
     * @return string
     */
    public function getStayBegin()
    {
        return $this->StayBegin;
    }
    /**
     * Set StayBegin value
     * @param string $stayBegin
     * @return \StructType\TunnelStay
     */
    public function setStayBegin($stayBegin = null)
    {
        // validation for constraint: string
        if (!is_null($stayBegin) && !is_string($stayBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stayBegin, true), gettype($stayBegin)), __LINE__);
        }
        $this->StayBegin = $stayBegin;
        return $this;
    }
    /**
     * Get StayEnd value
     * @return string
     */
    public function getStayEnd()
    {
        return $this->StayEnd;
    }
    /**
     * Set StayEnd value
     * @param string $stayEnd
     * @return \StructType\TunnelStay
     */
    public function setStayEnd($stayEnd = null)
    {
        // validation for constraint: string
        if (!is_null($stayEnd) && !is_string($stayEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stayEnd, true), gettype($stayEnd)), __LINE__);
        }
        $this->StayEnd = $stayEnd;
        return $this;
    }
    /**
     * Get GetStayNightDuration value
     * @return int
     */
    public function getGetStayNightDuration()
    {
        return $this->GetStayNightDuration;
    }
    /**
     * Set GetStayNightDuration value
     * @param int $getStayNightDuration
     * @return \StructType\TunnelStay
     */
    public function setGetStayNightDuration($getStayNightDuration = null)
    {
        // validation for constraint: int
        if (!is_null($getStayNightDuration) && !(is_int($getStayNightDuration) || ctype_digit($getStayNightDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($getStayNightDuration, true), gettype($getStayNightDuration)), __LINE__);
        }
        $this->GetStayNightDuration = $getStayNightDuration;
        return $this;
    }
    /**
     * Get ProductChaineTraduction value
     * @return string|null
     */
    public function getProductChaineTraduction()
    {
        return $this->ProductChaineTraduction;
    }
    /**
     * Set ProductChaineTraduction value
     * @param string $productChaineTraduction
     * @return \StructType\TunnelStay
     */
    public function setProductChaineTraduction($productChaineTraduction = null)
    {
        // validation for constraint: string
        if (!is_null($productChaineTraduction) && !is_string($productChaineTraduction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productChaineTraduction, true), gettype($productChaineTraduction)), __LINE__);
        }
        $this->ProductChaineTraduction = $productChaineTraduction;
        return $this;
    }
    /**
     * Get ProductLabel value
     * @return string|null
     */
    public function getProductLabel()
    {
        return $this->ProductLabel;
    }
    /**
     * Set ProductLabel value
     * @param string $productLabel
     * @return \StructType\TunnelStay
     */
    public function setProductLabel($productLabel = null)
    {
        // validation for constraint: string
        if (!is_null($productLabel) && !is_string($productLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productLabel, true), gettype($productLabel)), __LINE__);
        }
        $this->ProductLabel = $productLabel;
        return $this;
    }
    /**
     * Get GridModelChaineTraduction value
     * @return string|null
     */
    public function getGridModelChaineTraduction()
    {
        return $this->GridModelChaineTraduction;
    }
    /**
     * Set GridModelChaineTraduction value
     * @param string $gridModelChaineTraduction
     * @return \StructType\TunnelStay
     */
    public function setGridModelChaineTraduction($gridModelChaineTraduction = null)
    {
        // validation for constraint: string
        if (!is_null($gridModelChaineTraduction) && !is_string($gridModelChaineTraduction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gridModelChaineTraduction, true), gettype($gridModelChaineTraduction)), __LINE__);
        }
        $this->GridModelChaineTraduction = $gridModelChaineTraduction;
        return $this;
    }
    /**
     * Get GridLabel value
     * @return string|null
     */
    public function getGridLabel()
    {
        return $this->GridLabel;
    }
    /**
     * Set GridLabel value
     * @param string $gridLabel
     * @return \StructType\TunnelStay
     */
    public function setGridLabel($gridLabel = null)
    {
        // validation for constraint: string
        if (!is_null($gridLabel) && !is_string($gridLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gridLabel, true), gettype($gridLabel)), __LINE__);
        }
        $this->GridLabel = $gridLabel;
        return $this;
    }
    /**
     * Get EstablishmentCommentary value
     * @return string|null
     */
    public function getEstablishmentCommentary()
    {
        return $this->EstablishmentCommentary;
    }
    /**
     * Set EstablishmentCommentary value
     * @param string $establishmentCommentary
     * @return \StructType\TunnelStay
     */
    public function setEstablishmentCommentary($establishmentCommentary = null)
    {
        // validation for constraint: string
        if (!is_null($establishmentCommentary) && !is_string($establishmentCommentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($establishmentCommentary, true), gettype($establishmentCommentary)), __LINE__);
        }
        $this->EstablishmentCommentary = $establishmentCommentary;
        return $this;
    }
}
