<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleInsurance StructType
 * @subpackage Structs
 */
class SimpleInsurance extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * The LabelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LabelName
     */
    public $LabelName;
    /**
     * Constructor method for SimpleInsurance
     * @uses SimpleInsurance::setId()
     * @uses SimpleInsurance::setPrice()
     * @uses SimpleInsurance::setLabelName()
     * @param int $id
     * @param float $price
     * @param \StructType\LabelName $labelName
     */
    public function __construct($id = null, $price = null, \StructType\LabelName $labelName = null)
    {
        $this
            ->setId($id)
            ->setPrice($price)
            ->setLabelName($labelName);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\SimpleInsurance
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\SimpleInsurance
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get LabelName value
     * @return \StructType\LabelName|null
     */
    public function getLabelName()
    {
        return $this->LabelName;
    }
    /**
     * Set LabelName value
     * @param \StructType\LabelName $labelName
     * @return \StructType\SimpleInsurance
     */
    public function setLabelName(\StructType\LabelName $labelName = null)
    {
        $this->LabelName = $labelName;
        return $this;
    }
}
