<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstablishmentPaymentMeanContext StructType
 * @subpackage Structs
 */
class EstablishmentPaymentMeanContext extends AbstractStructBase
{
    /**
     * The DepositBalance
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepositBalance;
    /**
     * The EnabledUntil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnabledUntil;
    /**
     * The EnabledFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnabledFrom;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEstablishmentPaymentMean
     */
    public $PaymentMeans;
    /**
     * Constructor method for EstablishmentPaymentMeanContext
     * @uses EstablishmentPaymentMeanContext::setDepositBalance()
     * @uses EstablishmentPaymentMeanContext::setEnabledUntil()
     * @uses EstablishmentPaymentMeanContext::setEnabledFrom()
     * @uses EstablishmentPaymentMeanContext::setPaymentMeans()
     * @param string $depositBalance
     * @param string $enabledUntil
     * @param string $enabledFrom
     * @param \ArrayType\ArrayOfEstablishmentPaymentMean $paymentMeans
     */
    public function __construct($depositBalance = null, $enabledUntil = null, $enabledFrom = null, \ArrayType\ArrayOfEstablishmentPaymentMean $paymentMeans = null)
    {
        $this
            ->setDepositBalance($depositBalance)
            ->setEnabledUntil($enabledUntil)
            ->setEnabledFrom($enabledFrom)
            ->setPaymentMeans($paymentMeans);
    }
    /**
     * Get DepositBalance value
     * @return string
     */
    public function getDepositBalance()
    {
        return $this->DepositBalance;
    }
    /**
     * Set DepositBalance value
     * @uses \EnumType\DepositBalanceEnum::valueIsValid()
     * @uses \EnumType\DepositBalanceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $depositBalance
     * @return \StructType\EstablishmentPaymentMeanContext
     */
    public function setDepositBalance($depositBalance = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepositBalanceEnum::valueIsValid($depositBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DepositBalanceEnum', is_array($depositBalance) ? implode(', ', $depositBalance) : var_export($depositBalance, true), implode(', ', \EnumType\DepositBalanceEnum::getValidValues())), __LINE__);
        }
        $this->DepositBalance = $depositBalance;
        return $this;
    }
    /**
     * Get EnabledUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnabledUntil()
    {
        return isset($this->EnabledUntil) ? $this->EnabledUntil : null;
    }
    /**
     * Set EnabledUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enabledUntil
     * @return \StructType\EstablishmentPaymentMeanContext
     */
    public function setEnabledUntil($enabledUntil = null)
    {
        // validation for constraint: string
        if (!is_null($enabledUntil) && !is_string($enabledUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enabledUntil, true), gettype($enabledUntil)), __LINE__);
        }
        if (is_null($enabledUntil) || (is_array($enabledUntil) && empty($enabledUntil))) {
            unset($this->EnabledUntil);
        } else {
            $this->EnabledUntil = $enabledUntil;
        }
        return $this;
    }
    /**
     * Get EnabledFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnabledFrom()
    {
        return isset($this->EnabledFrom) ? $this->EnabledFrom : null;
    }
    /**
     * Set EnabledFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enabledFrom
     * @return \StructType\EstablishmentPaymentMeanContext
     */
    public function setEnabledFrom($enabledFrom = null)
    {
        // validation for constraint: string
        if (!is_null($enabledFrom) && !is_string($enabledFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enabledFrom, true), gettype($enabledFrom)), __LINE__);
        }
        if (is_null($enabledFrom) || (is_array($enabledFrom) && empty($enabledFrom))) {
            unset($this->EnabledFrom);
        } else {
            $this->EnabledFrom = $enabledFrom;
        }
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \ArrayType\ArrayOfEstablishmentPaymentMean|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * Set PaymentMeans value
     * @param \ArrayType\ArrayOfEstablishmentPaymentMean $paymentMeans
     * @return \StructType\EstablishmentPaymentMeanContext
     */
    public function setPaymentMeans(\ArrayType\ArrayOfEstablishmentPaymentMean $paymentMeans = null)
    {
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
}
