<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDetail ArrayType
 * @subpackage Arrays
 */
class ArrayOfDetail extends AbstractStructArrayBase
{
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Detail[]
     */
    public $Detail;
    /**
     * Constructor method for ArrayOfDetail
     * @uses ArrayOfDetail::setDetail()
     * @param \StructType\Detail[] $detail
     */
    public function __construct(array $detail = array())
    {
        $this
            ->setDetail($detail);
    }
    /**
     * Get Detail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Detail[]|null
     */
    public function getDetail()
    {
        return isset($this->Detail) ? $this->Detail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailForArrayConstraintsFromSetDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDetailDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfDetailDetailItem instanceof \StructType\Detail) {
                $invalidValues[] = is_object($arrayOfDetailDetailItem) ? get_class($arrayOfDetailDetailItem) : sprintf('%s(%s)', gettype($arrayOfDetailDetailItem), var_export($arrayOfDetailDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Detail property can only contain items of type \StructType\Detail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Detail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Detail[] $detail
     * @return \ArrayType\ArrayOfDetail
     */
    public function setDetail(array $detail = array())
    {
        // validation for constraint: array
        if ('' !== ($detailArrayErrorMessage = self::validateDetailForArrayConstraintsFromSetDetail($detail))) {
            throw new \InvalidArgumentException($detailArrayErrorMessage, __LINE__);
        }
        if (is_null($detail) || (is_array($detail) && empty($detail))) {
            unset($this->Detail);
        } else {
            $this->Detail = $detail;
        }
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Detail $item
     * @return \ArrayType\ArrayOfDetail
     */
    public function addToDetail(\StructType\Detail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Detail) {
            throw new \InvalidArgumentException(sprintf('The Detail property can only contain items of type \StructType\Detail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Detail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Detail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Detail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Detail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Detail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Detail
     */
    public function getAttributeName()
    {
        return 'Detail';
    }
}
