<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAllot ArrayType
 * @subpackage Arrays
 */
class ArrayOfAllot extends AbstractStructArrayBase
{
    /**
     * The Allot
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Allot[]
     */
    public $Allot;
    /**
     * Constructor method for ArrayOfAllot
     * @uses ArrayOfAllot::setAllot()
     * @param \StructType\Allot[] $allot
     */
    public function __construct(array $allot = array())
    {
        $this
            ->setAllot($allot);
    }
    /**
     * Get Allot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Allot[]|null
     */
    public function getAllot()
    {
        return isset($this->Allot) ? $this->Allot : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAllot method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllot method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllotForArrayConstraintsFromSetAllot(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAllotAllotItem) {
            // validation for constraint: itemType
            if (!$arrayOfAllotAllotItem instanceof \StructType\Allot) {
                $invalidValues[] = is_object($arrayOfAllotAllotItem) ? get_class($arrayOfAllotAllotItem) : sprintf('%s(%s)', gettype($arrayOfAllotAllotItem), var_export($arrayOfAllotAllotItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Allot property can only contain items of type \StructType\Allot, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Allot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Allot[] $allot
     * @return \ArrayType\ArrayOfAllot
     */
    public function setAllot(array $allot = array())
    {
        // validation for constraint: array
        if ('' !== ($allotArrayErrorMessage = self::validateAllotForArrayConstraintsFromSetAllot($allot))) {
            throw new \InvalidArgumentException($allotArrayErrorMessage, __LINE__);
        }
        if (is_null($allot) || (is_array($allot) && empty($allot))) {
            unset($this->Allot);
        } else {
            $this->Allot = $allot;
        }
        return $this;
    }
    /**
     * Add item to Allot value
     * @throws \InvalidArgumentException
     * @param \StructType\Allot $item
     * @return \ArrayType\ArrayOfAllot
     */
    public function addToAllot(\StructType\Allot $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Allot) {
            throw new \InvalidArgumentException(sprintf('The Allot property can only contain items of type \StructType\Allot, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Allot[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Allot|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Allot|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Allot|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Allot|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Allot|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Allot
     */
    public function getAttributeName()
    {
        return 'Allot';
    }
}
