<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for photoInfo StructType
 * @subpackage Structs
 */
class PhotoInfo extends AbstractStructBase
{
    /**
     * The myCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $myCategory;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $order;
    /**
     * The orderAnwb
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $orderAnwb;
    /**
     * The originalWidth
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $originalWidth;
    /**
     * The originalHeight
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $originalHeight;
    /**
     * The originalFileSize
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $originalFileSize;
    /**
     * The myDefaultUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myDefaultUrl;
    /**
     * The myBestSizeUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myBestSizeUrl;
    /**
     * The LinkedItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemInfo[]
     */
    public $LinkedItem;
    /**
     * The myFormats
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhotoFormat[]
     */
    public $myFormats;
    /**
     * The myKey
     * @var string
     */
    public $myKey;
    /**
     * Constructor method for photoInfo
     * @uses PhotoInfo::setMyCategory()
     * @uses PhotoInfo::setOrder()
     * @uses PhotoInfo::setOrderAnwb()
     * @uses PhotoInfo::setOriginalWidth()
     * @uses PhotoInfo::setOriginalHeight()
     * @uses PhotoInfo::setOriginalFileSize()
     * @uses PhotoInfo::setMyDefaultUrl()
     * @uses PhotoInfo::setMyBestSizeUrl()
     * @uses PhotoInfo::setLinkedItem()
     * @uses PhotoInfo::setMyFormats()
     * @uses PhotoInfo::setMyKey()
     * @param string $myCategory
     * @param int $order
     * @param int $orderAnwb
     * @param int $originalWidth
     * @param int $originalHeight
     * @param int $originalFileSize
     * @param string $myDefaultUrl
     * @param string $myBestSizeUrl
     * @param \StructType\ItemInfo[] $linkedItem
     * @param \StructType\PhotoFormat[] $myFormats
     * @param string $myKey
     */
    public function __construct($myCategory = null, $order = null, $orderAnwb = null, $originalWidth = null, $originalHeight = null, $originalFileSize = null, $myDefaultUrl = null, $myBestSizeUrl = null, array $linkedItem = array(), array $myFormats = array(), $myKey = null)
    {
        $this
            ->setMyCategory($myCategory)
            ->setOrder($order)
            ->setOrderAnwb($orderAnwb)
            ->setOriginalWidth($originalWidth)
            ->setOriginalHeight($originalHeight)
            ->setOriginalFileSize($originalFileSize)
            ->setMyDefaultUrl($myDefaultUrl)
            ->setMyBestSizeUrl($myBestSizeUrl)
            ->setLinkedItem($linkedItem)
            ->setMyFormats($myFormats)
            ->setMyKey($myKey);
    }
    /**
     * Get myCategory value
     * @return string
     */
    public function getMyCategory()
    {
        return $this->myCategory;
    }
    /**
     * Set myCategory value
     * @uses \EnumType\PhotoCategory::valueIsValid()
     * @uses \EnumType\PhotoCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $myCategory
     * @return \StructType\PhotoInfo
     */
    public function setMyCategory($myCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PhotoCategory::valueIsValid($myCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PhotoCategory', is_array($myCategory) ? implode(', ', $myCategory) : var_export($myCategory, true), implode(', ', \EnumType\PhotoCategory::getValidValues())), __LINE__);
        }
        $this->myCategory = $myCategory;
        return $this;
    }
    /**
     * Get order value
     * @return int
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \StructType\PhotoInfo
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get orderAnwb value
     * @return int
     */
    public function getOrderAnwb()
    {
        return $this->orderAnwb;
    }
    /**
     * Set orderAnwb value
     * @param int $orderAnwb
     * @return \StructType\PhotoInfo
     */
    public function setOrderAnwb($orderAnwb = null)
    {
        // validation for constraint: int
        if (!is_null($orderAnwb) && !(is_int($orderAnwb) || ctype_digit($orderAnwb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderAnwb, true), gettype($orderAnwb)), __LINE__);
        }
        $this->orderAnwb = $orderAnwb;
        return $this;
    }
    /**
     * Get originalWidth value
     * @return int
     */
    public function getOriginalWidth()
    {
        return $this->originalWidth;
    }
    /**
     * Set originalWidth value
     * @param int $originalWidth
     * @return \StructType\PhotoInfo
     */
    public function setOriginalWidth($originalWidth = null)
    {
        // validation for constraint: int
        if (!is_null($originalWidth) && !(is_int($originalWidth) || ctype_digit($originalWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalWidth, true), gettype($originalWidth)), __LINE__);
        }
        $this->originalWidth = $originalWidth;
        return $this;
    }
    /**
     * Get originalHeight value
     * @return int
     */
    public function getOriginalHeight()
    {
        return $this->originalHeight;
    }
    /**
     * Set originalHeight value
     * @param int $originalHeight
     * @return \StructType\PhotoInfo
     */
    public function setOriginalHeight($originalHeight = null)
    {
        // validation for constraint: int
        if (!is_null($originalHeight) && !(is_int($originalHeight) || ctype_digit($originalHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalHeight, true), gettype($originalHeight)), __LINE__);
        }
        $this->originalHeight = $originalHeight;
        return $this;
    }
    /**
     * Get originalFileSize value
     * @return int
     */
    public function getOriginalFileSize()
    {
        return $this->originalFileSize;
    }
    /**
     * Set originalFileSize value
     * @param int $originalFileSize
     * @return \StructType\PhotoInfo
     */
    public function setOriginalFileSize($originalFileSize = null)
    {
        // validation for constraint: int
        if (!is_null($originalFileSize) && !(is_int($originalFileSize) || ctype_digit($originalFileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalFileSize, true), gettype($originalFileSize)), __LINE__);
        }
        $this->originalFileSize = $originalFileSize;
        return $this;
    }
    /**
     * Get myDefaultUrl value
     * @return string|null
     */
    public function getMyDefaultUrl()
    {
        return $this->myDefaultUrl;
    }
    /**
     * Set myDefaultUrl value
     * @param string $myDefaultUrl
     * @return \StructType\PhotoInfo
     */
    public function setMyDefaultUrl($myDefaultUrl = null)
    {
        // validation for constraint: string
        if (!is_null($myDefaultUrl) && !is_string($myDefaultUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myDefaultUrl, true), gettype($myDefaultUrl)), __LINE__);
        }
        $this->myDefaultUrl = $myDefaultUrl;
        return $this;
    }
    /**
     * Get myBestSizeUrl value
     * @return string|null
     */
    public function getMyBestSizeUrl()
    {
        return $this->myBestSizeUrl;
    }
    /**
     * Set myBestSizeUrl value
     * @param string $myBestSizeUrl
     * @return \StructType\PhotoInfo
     */
    public function setMyBestSizeUrl($myBestSizeUrl = null)
    {
        // validation for constraint: string
        if (!is_null($myBestSizeUrl) && !is_string($myBestSizeUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myBestSizeUrl, true), gettype($myBestSizeUrl)), __LINE__);
        }
        $this->myBestSizeUrl = $myBestSizeUrl;
        return $this;
    }
    /**
     * Get LinkedItem value
     * @return \StructType\ItemInfo[]|null
     */
    public function getLinkedItem()
    {
        return $this->LinkedItem;
    }
    /**
     * This method is responsible for validating the values passed to the setLinkedItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinkedItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinkedItemForArrayConstraintsFromSetLinkedItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $photoInfoLinkedItemItem) {
            // validation for constraint: itemType
            if (!$photoInfoLinkedItemItem instanceof \StructType\ItemInfo) {
                $invalidValues[] = is_object($photoInfoLinkedItemItem) ? get_class($photoInfoLinkedItemItem) : sprintf('%s(%s)', gettype($photoInfoLinkedItemItem), var_export($photoInfoLinkedItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LinkedItem property can only contain items of type \StructType\ItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LinkedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo[] $linkedItem
     * @return \StructType\PhotoInfo
     */
    public function setLinkedItem(array $linkedItem = array())
    {
        // validation for constraint: array
        if ('' !== ($linkedItemArrayErrorMessage = self::validateLinkedItemForArrayConstraintsFromSetLinkedItem($linkedItem))) {
            throw new \InvalidArgumentException($linkedItemArrayErrorMessage, __LINE__);
        }
        $this->LinkedItem = $linkedItem;
        return $this;
    }
    /**
     * Add item to LinkedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo $item
     * @return \StructType\PhotoInfo
     */
    public function addToLinkedItem(\StructType\ItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemInfo) {
            throw new \InvalidArgumentException(sprintf('The LinkedItem property can only contain items of type \StructType\ItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LinkedItem[] = $item;
        return $this;
    }
    /**
     * Get myFormats value
     * @return \StructType\PhotoFormat[]|null
     */
    public function getMyFormats()
    {
        return $this->myFormats;
    }
    /**
     * This method is responsible for validating the values passed to the setMyFormats method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyFormats method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyFormatsForArrayConstraintsFromSetMyFormats(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $photoInfoMyFormatsItem) {
            // validation for constraint: itemType
            if (!$photoInfoMyFormatsItem instanceof \StructType\PhotoFormat) {
                $invalidValues[] = is_object($photoInfoMyFormatsItem) ? get_class($photoInfoMyFormatsItem) : sprintf('%s(%s)', gettype($photoInfoMyFormatsItem), var_export($photoInfoMyFormatsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myFormats property can only contain items of type \StructType\PhotoFormat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myFormats value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoFormat[] $myFormats
     * @return \StructType\PhotoInfo
     */
    public function setMyFormats(array $myFormats = array())
    {
        // validation for constraint: array
        if ('' !== ($myFormatsArrayErrorMessage = self::validateMyFormatsForArrayConstraintsFromSetMyFormats($myFormats))) {
            throw new \InvalidArgumentException($myFormatsArrayErrorMessage, __LINE__);
        }
        $this->myFormats = $myFormats;
        return $this;
    }
    /**
     * Add item to myFormats value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoFormat $item
     * @return \StructType\PhotoInfo
     */
    public function addToMyFormats(\StructType\PhotoFormat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhotoFormat) {
            throw new \InvalidArgumentException(sprintf('The myFormats property can only contain items of type \StructType\PhotoFormat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myFormats[] = $item;
        return $this;
    }
    /**
     * Get myKey value
     * @return string|null
     */
    public function getMyKey()
    {
        return $this->myKey;
    }
    /**
     * Set myKey value
     * @param string $myKey
     * @return \StructType\PhotoInfo
     */
    public function setMyKey($myKey = null)
    {
        // validation for constraint: string
        if (!is_null($myKey) && !is_string($myKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myKey, true), gettype($myKey)), __LINE__);
        }
        $this->myKey = $myKey;
        return $this;
    }
}
