<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Option StructType
 * @subpackage Structs
 */
class Option_1 extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The OptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptionId;
    /**
     * Constructor method for Option
     * @uses Option_1::setQuantity()
     * @uses Option_1::setOptionId()
     * @param int $quantity
     * @param string $optionId
     */
    public function __construct($quantity = null, $optionId = null)
    {
        $this
            ->setQuantity($quantity)
            ->setOptionId($optionId);
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Option_1
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get OptionId value
     * @return string|null
     */
    public function getOptionId()
    {
        return $this->OptionId;
    }
    /**
     * Set OptionId value
     * @param string $optionId
     * @return \StructType\Option_1
     */
    public function setOptionId($optionId = null)
    {
        // validation for constraint: string
        if (!is_null($optionId) && !is_string($optionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionId, true), gettype($optionId)), __LINE__);
        }
        $this->OptionId = $optionId;
        return $this;
    }
}
