<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterAllotmentsInfo StructType
 * @subpackage Structs
 */
class FilterAllotmentsInfo extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The DetailByPeriods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DetailByPeriods;
    /**
     * The DetailByNight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DetailByNight;
    /**
     * The ProductIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ProductIds;
    /**
     * The EstablishmentIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $EstablishmentIds;
    /**
     * Constructor method for FilterAllotmentsInfo
     * @uses FilterAllotmentsInfo::setStartDate()
     * @uses FilterAllotmentsInfo::setEndDate()
     * @uses FilterAllotmentsInfo::setDetailByPeriods()
     * @uses FilterAllotmentsInfo::setDetailByNight()
     * @uses FilterAllotmentsInfo::setProductIds()
     * @uses FilterAllotmentsInfo::setEstablishmentIds()
     * @param string $startDate
     * @param string $endDate
     * @param bool $detailByPeriods
     * @param bool $detailByNight
     * @param \ArrayType\ArrayOfInt $productIds
     * @param \ArrayType\ArrayOfInt $establishmentIds
     */
    public function __construct($startDate = null, $endDate = null, $detailByPeriods = null, $detailByNight = null, \ArrayType\ArrayOfInt $productIds = null, \ArrayType\ArrayOfInt $establishmentIds = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setDetailByPeriods($detailByPeriods)
            ->setDetailByNight($detailByNight)
            ->setProductIds($productIds)
            ->setEstablishmentIds($establishmentIds);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\FilterAllotmentsInfo
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\FilterAllotmentsInfo
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get DetailByPeriods value
     * @return bool
     */
    public function getDetailByPeriods()
    {
        return $this->DetailByPeriods;
    }
    /**
     * Set DetailByPeriods value
     * @param bool $detailByPeriods
     * @return \StructType\FilterAllotmentsInfo
     */
    public function setDetailByPeriods($detailByPeriods = null)
    {
        // validation for constraint: boolean
        if (!is_null($detailByPeriods) && !is_bool($detailByPeriods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($detailByPeriods, true), gettype($detailByPeriods)), __LINE__);
        }
        $this->DetailByPeriods = $detailByPeriods;
        return $this;
    }
    /**
     * Get DetailByNight value
     * @return bool
     */
    public function getDetailByNight()
    {
        return $this->DetailByNight;
    }
    /**
     * Set DetailByNight value
     * @param bool $detailByNight
     * @return \StructType\FilterAllotmentsInfo
     */
    public function setDetailByNight($detailByNight = null)
    {
        // validation for constraint: boolean
        if (!is_null($detailByNight) && !is_bool($detailByNight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($detailByNight, true), gettype($detailByNight)), __LINE__);
        }
        $this->DetailByNight = $detailByNight;
        return $this;
    }
    /**
     * Get ProductIds value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getProductIds()
    {
        return $this->ProductIds;
    }
    /**
     * Set ProductIds value
     * @param \ArrayType\ArrayOfInt $productIds
     * @return \StructType\FilterAllotmentsInfo
     */
    public function setProductIds(\ArrayType\ArrayOfInt $productIds = null)
    {
        $this->ProductIds = $productIds;
        return $this;
    }
    /**
     * Get EstablishmentIds value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getEstablishmentIds()
    {
        return $this->EstablishmentIds;
    }
    /**
     * Set EstablishmentIds value
     * @param \ArrayType\ArrayOfInt $establishmentIds
     * @return \StructType\FilterAllotmentsInfo
     */
    public function setEstablishmentIds(\ArrayType\ArrayOfInt $establishmentIds = null)
    {
        $this->EstablishmentIds = $establishmentIds;
        return $this;
    }
}
