<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country StructType
 * @subpackage Structs
 */
class Country extends AbstractStructBase
{
    /**
     * The geonameid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $geonameid;
    /**
     * The nboffers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nboffers;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for Country
     * @uses Country::setGeonameid()
     * @uses Country::setNboffers()
     * @uses Country::setCode()
     * @uses Country::setName()
     * @param int $geonameid
     * @param int $nboffers
     * @param string $code
     * @param string $name
     */
    public function __construct($geonameid = null, $nboffers = null, $code = null, $name = null)
    {
        $this
            ->setGeonameid($geonameid)
            ->setNboffers($nboffers)
            ->setCode($code)
            ->setName($name);
    }
    /**
     * Get geonameid value
     * @return int
     */
    public function getGeonameid()
    {
        return $this->geonameid;
    }
    /**
     * Set geonameid value
     * @param int $geonameid
     * @return \StructType\Country
     */
    public function setGeonameid($geonameid = null)
    {
        // validation for constraint: int
        if (!is_null($geonameid) && !(is_int($geonameid) || ctype_digit($geonameid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geonameid, true), gettype($geonameid)), __LINE__);
        }
        $this->geonameid = $geonameid;
        return $this;
    }
    /**
     * Get nboffers value
     * @return int
     */
    public function getNboffers()
    {
        return $this->nboffers;
    }
    /**
     * Set nboffers value
     * @param int $nboffers
     * @return \StructType\Country
     */
    public function setNboffers($nboffers = null)
    {
        // validation for constraint: int
        if (!is_null($nboffers) && !(is_int($nboffers) || ctype_digit($nboffers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nboffers, true), gettype($nboffers)), __LINE__);
        }
        $this->nboffers = $nboffers;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Country
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Country
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
