<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString1 extends AbstractStructArrayBase
{
    /**
     * The url
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $url;
    /**
     * Constructor method for ArrayOfString1
     * @uses ArrayOfString1::setUrl()
     * @param string[] $url
     */
    public function __construct(array $url = array())
    {
        $this
            ->setUrl($url);
    }
    /**
     * Get url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getUrl()
    {
        return isset($this->url) ? $this->url : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUrl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUrl method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUrlForArrayConstraintsFromSetUrl(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString1UrlItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString1UrlItem)) {
                $invalidValues[] = is_object($arrayOfString1UrlItem) ? get_class($arrayOfString1UrlItem) : sprintf('%s(%s)', gettype($arrayOfString1UrlItem), var_export($arrayOfString1UrlItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The url property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $url
     * @return \ArrayType\ArrayOfString1
     */
    public function setUrl(array $url = array())
    {
        // validation for constraint: array
        if ('' !== ($urlArrayErrorMessage = self::validateUrlForArrayConstraintsFromSetUrl($url))) {
            throw new \InvalidArgumentException($urlArrayErrorMessage, __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->url);
        } else {
            $this->url = $url;
        }
        return $this;
    }
    /**
     * Add item to url value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString1
     */
    public function addToUrl($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The url property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->url[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string url
     */
    public function getAttributeName()
    {
        return 'url';
    }
}
