<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TunnelOption StructType
 * @subpackage Structs
 */
class TunnelOption extends AbstractStructBase
{
    /**
     * The SelectedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SelectedQuantity;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The EnumTypeOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EnumTypeOption;
    /**
     * The QuantityIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $QuantityIncluded;
    /**
     * The IsClassicOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsClassicOption;
    /**
     * The IsPackageOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPackageOption;
    /**
     * The OptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptionId;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * The LabelChaineTraduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelChaineTraduction;
    /**
     * Constructor method for TunnelOption
     * @uses TunnelOption::setSelectedQuantity()
     * @uses TunnelOption::setTotalPrice()
     * @uses TunnelOption::setEnumTypeOption()
     * @uses TunnelOption::setQuantityIncluded()
     * @uses TunnelOption::setIsClassicOption()
     * @uses TunnelOption::setIsPackageOption()
     * @uses TunnelOption::setOptionId()
     * @uses TunnelOption::setLabel()
     * @uses TunnelOption::setLabelChaineTraduction()
     * @param int $selectedQuantity
     * @param float $totalPrice
     * @param string $enumTypeOption
     * @param int $quantityIncluded
     * @param bool $isClassicOption
     * @param bool $isPackageOption
     * @param string $optionId
     * @param string $label
     * @param string $labelChaineTraduction
     */
    public function __construct($selectedQuantity = null, $totalPrice = null, $enumTypeOption = null, $quantityIncluded = null, $isClassicOption = null, $isPackageOption = null, $optionId = null, $label = null, $labelChaineTraduction = null)
    {
        $this
            ->setSelectedQuantity($selectedQuantity)
            ->setTotalPrice($totalPrice)
            ->setEnumTypeOption($enumTypeOption)
            ->setQuantityIncluded($quantityIncluded)
            ->setIsClassicOption($isClassicOption)
            ->setIsPackageOption($isPackageOption)
            ->setOptionId($optionId)
            ->setLabel($label)
            ->setLabelChaineTraduction($labelChaineTraduction);
    }
    /**
     * Get SelectedQuantity value
     * @return int
     */
    public function getSelectedQuantity()
    {
        return $this->SelectedQuantity;
    }
    /**
     * Set SelectedQuantity value
     * @param int $selectedQuantity
     * @return \StructType\TunnelOption
     */
    public function setSelectedQuantity($selectedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($selectedQuantity) && !(is_int($selectedQuantity) || ctype_digit($selectedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedQuantity, true), gettype($selectedQuantity)), __LINE__);
        }
        $this->SelectedQuantity = $selectedQuantity;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\TunnelOption
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get EnumTypeOption value
     * @return string
     */
    public function getEnumTypeOption()
    {
        return $this->EnumTypeOption;
    }
    /**
     * Set EnumTypeOption value
     * @uses \EnumType\EnumTypeOption::valueIsValid()
     * @uses \EnumType\EnumTypeOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $enumTypeOption
     * @return \StructType\TunnelOption
     */
    public function setEnumTypeOption($enumTypeOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTypeOption::valueIsValid($enumTypeOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTypeOption', is_array($enumTypeOption) ? implode(', ', $enumTypeOption) : var_export($enumTypeOption, true), implode(', ', \EnumType\EnumTypeOption::getValidValues())), __LINE__);
        }
        $this->EnumTypeOption = $enumTypeOption;
        return $this;
    }
    /**
     * Get QuantityIncluded value
     * @return int
     */
    public function getQuantityIncluded()
    {
        return $this->QuantityIncluded;
    }
    /**
     * Set QuantityIncluded value
     * @param int $quantityIncluded
     * @return \StructType\TunnelOption
     */
    public function setQuantityIncluded($quantityIncluded = null)
    {
        // validation for constraint: int
        if (!is_null($quantityIncluded) && !(is_int($quantityIncluded) || ctype_digit($quantityIncluded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityIncluded, true), gettype($quantityIncluded)), __LINE__);
        }
        $this->QuantityIncluded = $quantityIncluded;
        return $this;
    }
    /**
     * Get IsClassicOption value
     * @return bool
     */
    public function getIsClassicOption()
    {
        return $this->IsClassicOption;
    }
    /**
     * Set IsClassicOption value
     * @param bool $isClassicOption
     * @return \StructType\TunnelOption
     */
    public function setIsClassicOption($isClassicOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClassicOption) && !is_bool($isClassicOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClassicOption, true), gettype($isClassicOption)), __LINE__);
        }
        $this->IsClassicOption = $isClassicOption;
        return $this;
    }
    /**
     * Get IsPackageOption value
     * @return bool
     */
    public function getIsPackageOption()
    {
        return $this->IsPackageOption;
    }
    /**
     * Set IsPackageOption value
     * @param bool $isPackageOption
     * @return \StructType\TunnelOption
     */
    public function setIsPackageOption($isPackageOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPackageOption) && !is_bool($isPackageOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPackageOption, true), gettype($isPackageOption)), __LINE__);
        }
        $this->IsPackageOption = $isPackageOption;
        return $this;
    }
    /**
     * Get OptionId value
     * @return string|null
     */
    public function getOptionId()
    {
        return $this->OptionId;
    }
    /**
     * Set OptionId value
     * @param string $optionId
     * @return \StructType\TunnelOption
     */
    public function setOptionId($optionId = null)
    {
        // validation for constraint: string
        if (!is_null($optionId) && !is_string($optionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionId, true), gettype($optionId)), __LINE__);
        }
        $this->OptionId = $optionId;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \StructType\TunnelOption
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Get LabelChaineTraduction value
     * @return string|null
     */
    public function getLabelChaineTraduction()
    {
        return $this->LabelChaineTraduction;
    }
    /**
     * Set LabelChaineTraduction value
     * @param string $labelChaineTraduction
     * @return \StructType\TunnelOption
     */
    public function setLabelChaineTraduction($labelChaineTraduction = null)
    {
        // validation for constraint: string
        if (!is_null($labelChaineTraduction) && !is_string($labelChaineTraduction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelChaineTraduction, true), gettype($labelChaineTraduction)), __LINE__);
        }
        $this->LabelChaineTraduction = $labelChaineTraduction;
        return $this;
    }
}
