<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductInformations ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductInformations extends AbstractStructArrayBase
{
    /**
     * The productInformations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductInformations[]
     */
    public $productInformations;
    /**
     * Constructor method for ArrayOfProductInformations
     * @uses ArrayOfProductInformations::setProductInformations()
     * @param \StructType\ProductInformations[] $productInformations
     */
    public function __construct(array $productInformations = array())
    {
        $this
            ->setProductInformations($productInformations);
    }
    /**
     * Get productInformations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductInformations[]|null
     */
    public function getProductInformations()
    {
        return isset($this->productInformations) ? $this->productInformations : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductInformations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductInformations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductInformationsForArrayConstraintsFromSetProductInformations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductInformationsProductInformationsItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductInformationsProductInformationsItem instanceof \StructType\ProductInformations) {
                $invalidValues[] = is_object($arrayOfProductInformationsProductInformationsItem) ? get_class($arrayOfProductInformationsProductInformationsItem) : sprintf('%s(%s)', gettype($arrayOfProductInformationsProductInformationsItem), var_export($arrayOfProductInformationsProductInformationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productInformations property can only contain items of type \StructType\ProductInformations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productInformations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInformations[] $productInformations
     * @return \ArrayType\ArrayOfProductInformations
     */
    public function setProductInformations(array $productInformations = array())
    {
        // validation for constraint: array
        if ('' !== ($productInformationsArrayErrorMessage = self::validateProductInformationsForArrayConstraintsFromSetProductInformations($productInformations))) {
            throw new \InvalidArgumentException($productInformationsArrayErrorMessage, __LINE__);
        }
        if (is_null($productInformations) || (is_array($productInformations) && empty($productInformations))) {
            unset($this->productInformations);
        } else {
            $this->productInformations = $productInformations;
        }
        return $this;
    }
    /**
     * Add item to productInformations value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInformations $item
     * @return \ArrayType\ArrayOfProductInformations
     */
    public function addToProductInformations(\StructType\ProductInformations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInformations) {
            throw new \InvalidArgumentException(sprintf('The productInformations property can only contain items of type \StructType\ProductInformations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productInformations[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductInformations|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductInformations|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductInformations|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductInformations|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductInformations|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string productInformations
     */
    public function getAttributeName()
    {
        return 'productInformations';
    }
}
