<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductPricing ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductPricing extends AbstractStructArrayBase
{
    /**
     * The productPricing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductPricing[]
     */
    public $productPricing;
    /**
     * Constructor method for ArrayOfProductPricing
     * @uses ArrayOfProductPricing::setProductPricing()
     * @param \StructType\ProductPricing[] $productPricing
     */
    public function __construct(array $productPricing = array())
    {
        $this
            ->setProductPricing($productPricing);
    }
    /**
     * Get productPricing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductPricing[]|null
     */
    public function getProductPricing()
    {
        return isset($this->productPricing) ? $this->productPricing : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductPricing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductPricing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductPricingForArrayConstraintsFromSetProductPricing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductPricingProductPricingItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductPricingProductPricingItem instanceof \StructType\ProductPricing) {
                $invalidValues[] = is_object($arrayOfProductPricingProductPricingItem) ? get_class($arrayOfProductPricingProductPricingItem) : sprintf('%s(%s)', gettype($arrayOfProductPricingProductPricingItem), var_export($arrayOfProductPricingProductPricingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productPricing property can only contain items of type \StructType\ProductPricing, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productPricing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPricing[] $productPricing
     * @return \ArrayType\ArrayOfProductPricing
     */
    public function setProductPricing(array $productPricing = array())
    {
        // validation for constraint: array
        if ('' !== ($productPricingArrayErrorMessage = self::validateProductPricingForArrayConstraintsFromSetProductPricing($productPricing))) {
            throw new \InvalidArgumentException($productPricingArrayErrorMessage, __LINE__);
        }
        if (is_null($productPricing) || (is_array($productPricing) && empty($productPricing))) {
            unset($this->productPricing);
        } else {
            $this->productPricing = $productPricing;
        }
        return $this;
    }
    /**
     * Add item to productPricing value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPricing $item
     * @return \ArrayType\ArrayOfProductPricing
     */
    public function addToProductPricing(\StructType\ProductPricing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductPricing) {
            throw new \InvalidArgumentException(sprintf('The productPricing property can only contain items of type \StructType\ProductPricing, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productPricing[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductPricing|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductPricing|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductPricing|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductPricing|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductPricing|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string productPricing
     */
    public function getAttributeName()
    {
        return 'productPricing';
    }
}
