<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for establishmentInfo StructType
 * @subpackage Structs
 */
class EstablishmentInfo extends BaseEntityInfo
{
    /**
     * The myKeySH
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $myKeySH;
    /**
     * The myFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemInfo[]
     */
    public $myFeatures;
    /**
     * The myProducts
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductInfo[]
     */
    public $myProducts;
    /**
     * The myTexts
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TextInfo[]
     */
    public $myTexts;
    /**
     * Constructor method for establishmentInfo
     * @uses EstablishmentInfo::setMyKeySH()
     * @uses EstablishmentInfo::setMyFeatures()
     * @uses EstablishmentInfo::setMyProducts()
     * @uses EstablishmentInfo::setMyTexts()
     * @param int $myKeySH
     * @param \StructType\ItemInfo[] $myFeatures
     * @param \StructType\ProductInfo[] $myProducts
     * @param \StructType\TextInfo[] $myTexts
     */
    public function __construct($myKeySH = null, array $myFeatures = array(), array $myProducts = array(), array $myTexts = array())
    {
        $this
            ->setMyKeySH($myKeySH)
            ->setMyFeatures($myFeatures)
            ->setMyProducts($myProducts)
            ->setMyTexts($myTexts);
    }
    /**
     * Get myKeySH value
     * @return int
     */
    public function getMyKeySH()
    {
        return $this->myKeySH;
    }
    /**
     * Set myKeySH value
     * @param int $myKeySH
     * @return \StructType\EstablishmentInfo
     */
    public function setMyKeySH($myKeySH = null)
    {
        // validation for constraint: int
        if (!is_null($myKeySH) && !(is_int($myKeySH) || ctype_digit($myKeySH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myKeySH, true), gettype($myKeySH)), __LINE__);
        }
        $this->myKeySH = $myKeySH;
        return $this;
    }
    /**
     * Get myFeatures value
     * @return \StructType\ItemInfo[]|null
     */
    public function getMyFeatures()
    {
        return $this->myFeatures;
    }
    /**
     * This method is responsible for validating the values passed to the setMyFeatures method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyFeatures method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyFeaturesForArrayConstraintsFromSetMyFeatures(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentInfoMyFeaturesItem) {
            // validation for constraint: itemType
            if (!$establishmentInfoMyFeaturesItem instanceof \StructType\ItemInfo) {
                $invalidValues[] = is_object($establishmentInfoMyFeaturesItem) ? get_class($establishmentInfoMyFeaturesItem) : sprintf('%s(%s)', gettype($establishmentInfoMyFeaturesItem), var_export($establishmentInfoMyFeaturesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myFeatures property can only contain items of type \StructType\ItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myFeatures value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo[] $myFeatures
     * @return \StructType\EstablishmentInfo
     */
    public function setMyFeatures(array $myFeatures = array())
    {
        // validation for constraint: array
        if ('' !== ($myFeaturesArrayErrorMessage = self::validateMyFeaturesForArrayConstraintsFromSetMyFeatures($myFeatures))) {
            throw new \InvalidArgumentException($myFeaturesArrayErrorMessage, __LINE__);
        }
        $this->myFeatures = $myFeatures;
        return $this;
    }
    /**
     * Add item to myFeatures value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo $item
     * @return \StructType\EstablishmentInfo
     */
    public function addToMyFeatures(\StructType\ItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemInfo) {
            throw new \InvalidArgumentException(sprintf('The myFeatures property can only contain items of type \StructType\ItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myFeatures[] = $item;
        return $this;
    }
    /**
     * Get myProducts value
     * @return \StructType\ProductInfo[]|null
     */
    public function getMyProducts()
    {
        return $this->myProducts;
    }
    /**
     * This method is responsible for validating the values passed to the setMyProducts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyProducts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyProductsForArrayConstraintsFromSetMyProducts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentInfoMyProductsItem) {
            // validation for constraint: itemType
            if (!$establishmentInfoMyProductsItem instanceof \StructType\ProductInfo) {
                $invalidValues[] = is_object($establishmentInfoMyProductsItem) ? get_class($establishmentInfoMyProductsItem) : sprintf('%s(%s)', gettype($establishmentInfoMyProductsItem), var_export($establishmentInfoMyProductsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myProducts property can only contain items of type \StructType\ProductInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myProducts value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo[] $myProducts
     * @return \StructType\EstablishmentInfo
     */
    public function setMyProducts(array $myProducts = array())
    {
        // validation for constraint: array
        if ('' !== ($myProductsArrayErrorMessage = self::validateMyProductsForArrayConstraintsFromSetMyProducts($myProducts))) {
            throw new \InvalidArgumentException($myProductsArrayErrorMessage, __LINE__);
        }
        $this->myProducts = $myProducts;
        return $this;
    }
    /**
     * Add item to myProducts value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo $item
     * @return \StructType\EstablishmentInfo
     */
    public function addToMyProducts(\StructType\ProductInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInfo) {
            throw new \InvalidArgumentException(sprintf('The myProducts property can only contain items of type \StructType\ProductInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myProducts[] = $item;
        return $this;
    }
    /**
     * Get myTexts value
     * @return \StructType\TextInfo[]|null
     */
    public function getMyTexts()
    {
        return $this->myTexts;
    }
    /**
     * This method is responsible for validating the values passed to the setMyTexts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyTexts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyTextsForArrayConstraintsFromSetMyTexts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentInfoMyTextsItem) {
            // validation for constraint: itemType
            if (!$establishmentInfoMyTextsItem instanceof \StructType\TextInfo) {
                $invalidValues[] = is_object($establishmentInfoMyTextsItem) ? get_class($establishmentInfoMyTextsItem) : sprintf('%s(%s)', gettype($establishmentInfoMyTextsItem), var_export($establishmentInfoMyTextsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myTexts property can only contain items of type \StructType\TextInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myTexts value
     * @throws \InvalidArgumentException
     * @param \StructType\TextInfo[] $myTexts
     * @return \StructType\EstablishmentInfo
     */
    public function setMyTexts(array $myTexts = array())
    {
        // validation for constraint: array
        if ('' !== ($myTextsArrayErrorMessage = self::validateMyTextsForArrayConstraintsFromSetMyTexts($myTexts))) {
            throw new \InvalidArgumentException($myTextsArrayErrorMessage, __LINE__);
        }
        $this->myTexts = $myTexts;
        return $this;
    }
    /**
     * Add item to myTexts value
     * @throws \InvalidArgumentException
     * @param \StructType\TextInfo $item
     * @return \StructType\EstablishmentInfo
     */
    public function addToMyTexts(\StructType\TextInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TextInfo) {
            throw new \InvalidArgumentException(sprintf('The myTexts property can only contain items of type \StructType\TextInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myTexts[] = $item;
        return $this;
    }
}
