<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for availabilityInformations StructType
 * @subpackage Structs
 */
class AvailabilityInformations extends AbstractStructBase
{
    /**
     * The IsBookingEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsBookingEnabled;
    /**
     * The establishmentInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EstablishmentInformation
     */
    public $establishmentInformation;
    /**
     * The productInformationsList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductInformations
     */
    public $productInformationsList;
    /**
     * Constructor method for availabilityInformations
     * @uses AvailabilityInformations::setIsBookingEnabled()
     * @uses AvailabilityInformations::setEstablishmentInformation()
     * @uses AvailabilityInformations::setProductInformationsList()
     * @param bool $isBookingEnabled
     * @param \StructType\EstablishmentInformation $establishmentInformation
     * @param \ArrayType\ArrayOfProductInformations $productInformationsList
     */
    public function __construct($isBookingEnabled = null, \StructType\EstablishmentInformation $establishmentInformation = null, \ArrayType\ArrayOfProductInformations $productInformationsList = null)
    {
        $this
            ->setIsBookingEnabled($isBookingEnabled)
            ->setEstablishmentInformation($establishmentInformation)
            ->setProductInformationsList($productInformationsList);
    }
    /**
     * Get IsBookingEnabled value
     * @return bool
     */
    public function getIsBookingEnabled()
    {
        return $this->IsBookingEnabled;
    }
    /**
     * Set IsBookingEnabled value
     * @param bool $isBookingEnabled
     * @return \StructType\AvailabilityInformations
     */
    public function setIsBookingEnabled($isBookingEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBookingEnabled) && !is_bool($isBookingEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBookingEnabled, true), gettype($isBookingEnabled)), __LINE__);
        }
        $this->IsBookingEnabled = $isBookingEnabled;
        return $this;
    }
    /**
     * Get establishmentInformation value
     * @return \StructType\EstablishmentInformation|null
     */
    public function getEstablishmentInformation()
    {
        return $this->establishmentInformation;
    }
    /**
     * Set establishmentInformation value
     * @param \StructType\EstablishmentInformation $establishmentInformation
     * @return \StructType\AvailabilityInformations
     */
    public function setEstablishmentInformation(\StructType\EstablishmentInformation $establishmentInformation = null)
    {
        $this->establishmentInformation = $establishmentInformation;
        return $this;
    }
    /**
     * Get productInformationsList value
     * @return \ArrayType\ArrayOfProductInformations|null
     */
    public function getProductInformationsList()
    {
        return $this->productInformationsList;
    }
    /**
     * Set productInformationsList value
     * @param \ArrayType\ArrayOfProductInformations $productInformationsList
     * @return \StructType\AvailabilityInformations
     */
    public function setProductInformationsList(\ArrayType\ArrayOfProductInformations $productInformationsList = null)
    {
        $this->productInformationsList = $productInformationsList;
        return $this;
    }
}
