<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TunnelSpecialParams StructType
 * @subpackage Structs
 */
class TunnelSpecialParams extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The Guid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Guid;
    /**
     * The QuotationSubsidyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $QuotationSubsidyAmount;
    /**
     * The Tac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tac;
    /**
     * The Spec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spec;
    /**
     * The PaymentString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentString;
    /**
     * Constructor method for TunnelSpecialParams
     * @uses TunnelSpecialParams::setId()
     * @uses TunnelSpecialParams::setGuid()
     * @uses TunnelSpecialParams::setQuotationSubsidyAmount()
     * @uses TunnelSpecialParams::setTac()
     * @uses TunnelSpecialParams::setSpec()
     * @uses TunnelSpecialParams::setPaymentString()
     * @param int $id
     * @param string $guid
     * @param float $quotationSubsidyAmount
     * @param string $tac
     * @param string $spec
     * @param string $paymentString
     */
    public function __construct($id = null, $guid = null, $quotationSubsidyAmount = null, $tac = null, $spec = null, $paymentString = null)
    {
        $this
            ->setId($id)
            ->setGuid($guid)
            ->setQuotationSubsidyAmount($quotationSubsidyAmount)
            ->setTac($tac)
            ->setSpec($spec)
            ->setPaymentString($paymentString);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\TunnelSpecialParams
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Guid value
     * @return string
     */
    public function getGuid()
    {
        return $this->Guid;
    }
    /**
     * Set Guid value
     * @param string $guid
     * @return \StructType\TunnelSpecialParams
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($guid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($guid, true)), __LINE__);
        }
        $this->Guid = $guid;
        return $this;
    }
    /**
     * Get QuotationSubsidyAmount value
     * @return float
     */
    public function getQuotationSubsidyAmount()
    {
        return $this->QuotationSubsidyAmount;
    }
    /**
     * Set QuotationSubsidyAmount value
     * @param float $quotationSubsidyAmount
     * @return \StructType\TunnelSpecialParams
     */
    public function setQuotationSubsidyAmount($quotationSubsidyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($quotationSubsidyAmount) && !(is_float($quotationSubsidyAmount) || is_numeric($quotationSubsidyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quotationSubsidyAmount, true), gettype($quotationSubsidyAmount)), __LINE__);
        }
        $this->QuotationSubsidyAmount = $quotationSubsidyAmount;
        return $this;
    }
    /**
     * Get Tac value
     * @return string|null
     */
    public function getTac()
    {
        return $this->Tac;
    }
    /**
     * Set Tac value
     * @param string $tac
     * @return \StructType\TunnelSpecialParams
     */
    public function setTac($tac = null)
    {
        // validation for constraint: string
        if (!is_null($tac) && !is_string($tac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tac, true), gettype($tac)), __LINE__);
        }
        $this->Tac = $tac;
        return $this;
    }
    /**
     * Get Spec value
     * @return string|null
     */
    public function getSpec()
    {
        return $this->Spec;
    }
    /**
     * Set Spec value
     * @param string $spec
     * @return \StructType\TunnelSpecialParams
     */
    public function setSpec($spec = null)
    {
        // validation for constraint: string
        if (!is_null($spec) && !is_string($spec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spec, true), gettype($spec)), __LINE__);
        }
        $this->Spec = $spec;
        return $this;
    }
    /**
     * Get PaymentString value
     * @return string|null
     */
    public function getPaymentString()
    {
        return $this->PaymentString;
    }
    /**
     * Set PaymentString value
     * @param string $paymentString
     * @return \StructType\TunnelSpecialParams
     */
    public function setPaymentString($paymentString = null)
    {
        // validation for constraint: string
        if (!is_null($paymentString) && !is_string($paymentString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentString, true), gettype($paymentString)), __LINE__);
        }
        $this->PaymentString = $paymentString;
        return $this;
    }
}
