<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchQuote StructType
 * @subpackage Structs
 */
class SearchQuote extends AbstractStructBase
{
    /**
     * The establishmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $establishmentId;
    /**
     * The arrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $arrivalDate;
    /**
     * The departureDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $departureDate;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WSUser
     */
    public $user;
    /**
     * The isoLanguageCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $isoLanguageCode;
    /**
     * The guestList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuest
     */
    public $guestList;
    /**
     * Constructor method for SearchQuote
     * @uses SearchQuote::setEstablishmentId()
     * @uses SearchQuote::setArrivalDate()
     * @uses SearchQuote::setDepartureDate()
     * @uses SearchQuote::setUser()
     * @uses SearchQuote::setIsoLanguageCode()
     * @uses SearchQuote::setGuestList()
     * @param int $establishmentId
     * @param string $arrivalDate
     * @param string $departureDate
     * @param \StructType\WSUser $user
     * @param string $isoLanguageCode
     * @param \ArrayType\ArrayOfGuest $guestList
     */
    public function __construct($establishmentId = null, $arrivalDate = null, $departureDate = null, \StructType\WSUser $user = null, $isoLanguageCode = null, \ArrayType\ArrayOfGuest $guestList = null)
    {
        $this
            ->setEstablishmentId($establishmentId)
            ->setArrivalDate($arrivalDate)
            ->setDepartureDate($departureDate)
            ->setUser($user)
            ->setIsoLanguageCode($isoLanguageCode)
            ->setGuestList($guestList);
    }
    /**
     * Get establishmentId value
     * @return int
     */
    public function getEstablishmentId()
    {
        return $this->establishmentId;
    }
    /**
     * Set establishmentId value
     * @param int $establishmentId
     * @return \StructType\SearchQuote
     */
    public function setEstablishmentId($establishmentId = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentId) && !(is_int($establishmentId) || ctype_digit($establishmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentId, true), gettype($establishmentId)), __LINE__);
        }
        $this->establishmentId = $establishmentId;
        return $this;
    }
    /**
     * Get arrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->arrivalDate;
    }
    /**
     * Set arrivalDate value
     * @param string $arrivalDate
     * @return \StructType\SearchQuote
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->arrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get departureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }
    /**
     * Set departureDate value
     * @param string $departureDate
     * @return \StructType\SearchQuote
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->departureDate = $departureDate;
        return $this;
    }
    /**
     * Get user value
     * @return \StructType\WSUser|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param \StructType\WSUser $user
     * @return \StructType\SearchQuote
     */
    public function setUser(\StructType\WSUser $user = null)
    {
        $this->user = $user;
        return $this;
    }
    /**
     * Get isoLanguageCode value
     * @return string|null
     */
    public function getIsoLanguageCode()
    {
        return $this->isoLanguageCode;
    }
    /**
     * Set isoLanguageCode value
     * @param string $isoLanguageCode
     * @return \StructType\SearchQuote
     */
    public function setIsoLanguageCode($isoLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($isoLanguageCode) && !is_string($isoLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isoLanguageCode, true), gettype($isoLanguageCode)), __LINE__);
        }
        $this->isoLanguageCode = $isoLanguageCode;
        return $this;
    }
    /**
     * Get guestList value
     * @return \ArrayType\ArrayOfGuest|null
     */
    public function getGuestList()
    {
        return $this->guestList;
    }
    /**
     * Set guestList value
     * @param \ArrayType\ArrayOfGuest $guestList
     * @return \StructType\SearchQuote
     */
    public function setGuestList(\ArrayType\ArrayOfGuest $guestList = null)
    {
        $this->guestList = $guestList;
        return $this;
    }
}
