<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEntityTypeAttributes StructType
 * @subpackage Structs
 */
class GetEntityTypeAttributes extends AbstractStructBase
{
    /**
     * The engine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $engine;
    /**
     * The myEntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $myEntityType;
    /**
     * The usr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usr;
    /**
     * The pwd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pwd;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * Constructor method for getEntityTypeAttributes
     * @uses GetEntityTypeAttributes::setEngine()
     * @uses GetEntityTypeAttributes::setMyEntityType()
     * @uses GetEntityTypeAttributes::setUsr()
     * @uses GetEntityTypeAttributes::setPwd()
     * @uses GetEntityTypeAttributes::setLanguage()
     * @param int $engine
     * @param int $myEntityType
     * @param string $usr
     * @param string $pwd
     * @param string $language
     */
    public function __construct($engine = null, $myEntityType = null, $usr = null, $pwd = null, $language = null)
    {
        $this
            ->setEngine($engine)
            ->setMyEntityType($myEntityType)
            ->setUsr($usr)
            ->setPwd($pwd)
            ->setLanguage($language);
    }
    /**
     * Get engine value
     * @return int
     */
    public function getEngine()
    {
        return $this->engine;
    }
    /**
     * Set engine value
     * @param int $engine
     * @return \StructType\GetEntityTypeAttributes
     */
    public function setEngine($engine = null)
    {
        // validation for constraint: int
        if (!is_null($engine) && !(is_int($engine) || ctype_digit($engine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($engine, true), gettype($engine)), __LINE__);
        }
        $this->engine = $engine;
        return $this;
    }
    /**
     * Get myEntityType value
     * @return int
     */
    public function getMyEntityType()
    {
        return $this->myEntityType;
    }
    /**
     * Set myEntityType value
     * @param int $myEntityType
     * @return \StructType\GetEntityTypeAttributes
     */
    public function setMyEntityType($myEntityType = null)
    {
        // validation for constraint: int
        if (!is_null($myEntityType) && !(is_int($myEntityType) || ctype_digit($myEntityType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myEntityType, true), gettype($myEntityType)), __LINE__);
        }
        $this->myEntityType = $myEntityType;
        return $this;
    }
    /**
     * Get usr value
     * @return string|null
     */
    public function getUsr()
    {
        return $this->usr;
    }
    /**
     * Set usr value
     * @param string $usr
     * @return \StructType\GetEntityTypeAttributes
     */
    public function setUsr($usr = null)
    {
        // validation for constraint: string
        if (!is_null($usr) && !is_string($usr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usr, true), gettype($usr)), __LINE__);
        }
        $this->usr = $usr;
        return $this;
    }
    /**
     * Get pwd value
     * @return string|null
     */
    public function getPwd()
    {
        return $this->pwd;
    }
    /**
     * Set pwd value
     * @param string $pwd
     * @return \StructType\GetEntityTypeAttributes
     */
    public function setPwd($pwd = null)
    {
        // validation for constraint: string
        if (!is_null($pwd) && !is_string($pwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwd, true), gettype($pwd)), __LINE__);
        }
        $this->pwd = $pwd;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetEntityTypeAttributes
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
}
